/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.lib.util.WebUtils;

public class Profile {
    public String longHash = "";
    public String shortHash = "";
    public String mediumHash = "";
    private boolean online = false;
    public String display = "";
    public boolean premium = false;
    public String userDisplay = "";
    private boolean friend = false;
    private long lastFriendCheck = 0L;
    public String friendName = "";
    public String friendCode = "";
    private boolean banned = false;
    private String packID = "";
    private long lastOnlineCheck = 0L;
    private boolean isOnline = false;
    private boolean isLoadingProfile = false;
    private long profileAge;
    private boolean hasAccount = false;
    private boolean muted = false;
    private boolean isPartyMember = false;
    private boolean pending = false;

    public Profile(String serverNick) {
        if (serverNick.length() == 30) {
            this.mediumHash = serverNick;
            this.shortHash = serverNick.substring(0, 16);
            this.userDisplay = "User#" + this.mediumHash.substring(2, 7);
        } else if (serverNick.length() < 30) {
            this.shortHash = serverNick;
            this.userDisplay = "User#" + this.shortHash.substring(2, 7);
        } else {
            this.shortHash = "MT" + serverNick.substring(0, 14);
            this.mediumHash = "MT" + serverNick.substring(0, 28);
            this.longHash = serverNick;
            this.userDisplay = "User#" + this.longHash.substring(0, 5);
        }
    }

    public Profile(String longHash, String shortHash, String mediumHash, boolean online, String display, boolean premium) {
        this.longHash = longHash;
        this.shortHash = shortHash;
        this.mediumHash = mediumHash;
        this.online = online;
        this.display = display;
        this.premium = premium;
        this.userDisplay = "User#" + longHash.substring(0, 5);
        if (premium && display.length() > 0) {
            this.userDisplay = display;
        }
    }

    public Profile(String longHash, String shortHash, String mediumHash, boolean online, String display, boolean premium, String userDisplay) {
        this.longHash = longHash;
        this.shortHash = shortHash;
        this.mediumHash = mediumHash;
        this.online = online;
        this.display = display;
        this.premium = premium;
        this.userDisplay = userDisplay;
    }

    public String getLongHash() {
        return this.longHash;
    }

    @Deprecated
    public String getShortHash() {
        return this.shortHash;
    }

    public String getMediumHash() {
        return this.mediumHash;
    }

    public boolean isOnline() {
        long currentTime = System.currentTimeMillis() / 1000L;
        if (currentTime > this.lastOnlineCheck + 10L) {
            this.lastOnlineCheck = currentTime;
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IrcHandler.whois(this.mediumHash);
            }, MineTogetherChat.whoIsExecutor);
        }
        if (this.isOnline && !ChatHandler.friends.containsKey(this.mediumHash)) {
            ChatHandler.friends.put(this.mediumHash, this.friendName);
        } else if (!this.isOnline && ChatHandler.friends.containsKey(this.mediumHash)) {
            ChatHandler.friends.remove(this.mediumHash);
        }
        return this.isOnline;
    }

    public boolean isPartyMember() {
        return this.isPartyMember;
    }

    public void setPartyMember(boolean partyMember) {
        this.isPartyMember = partyMember;
    }

    public void setOnline(boolean online) {
        boolean oldOnline = this.isOnline;
        this.isOnline = online;
    }

    public boolean hasAccount() {
        return this.hasAccount;
    }

    public String getCurrentIRCNick() {
        return this.mediumHash;
    }

    public boolean isPremium() {
        return this.premium;
    }

    public String getConnectAddress() {
        return "2a04:de41:" + String.join((CharSequence)":", this.longHash.substring(0, 24).split("(?<=\\G....)")).toLowerCase();
    }

    public String getUserDisplay() {
        if (!this.userDisplay.isEmpty() && this.profileAge > 0L) {
            long age = System.currentTimeMillis() / 1000L - this.profileAge;
            if (this.hasAccount && age > 1800L || !this.hasAccount && age > 7200L) {
                CompletableFuture.runAsync(() -> this.loadProfile(), MineTogetherChat.profileExecutor);
            }
        }
        if (this.userDisplay.isEmpty() && this.longHash.length() > 0) {
            return "User#" + this.longHash.substring(5);
        }
        return this.userDisplay;
    }

    public String getFriendCode() {
        return this.friendCode;
    }

    public boolean isFriend() {
        return this.friend;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setFriend(boolean friend) {
        this.friend = friend;
    }

    public String getFriendName() {
        return this.friendName;
    }

    public void setFriendName(String friendName) {
        this.friendName = friendName;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean isBanned() {
        return this.banned;
    }

    public void setBanned(boolean banned) {
        this.banned = banned;
    }

    public void setPackID(String packID) {
        this.packID = packID;
    }

    public String getPackID() {
        return this.packID;
    }

    public boolean loadProfile() {
        JsonObject obj;
        JsonElement status;
        String playerHash;
        if (this.isLoadingProfile) {
            return false;
        }
        this.isLoadingProfile = true;
        String string = this.longHash.length() > 0 ? this.longHash : (playerHash = this.mediumHash.length() > 0 ? this.mediumHash : this.shortHash);
        if (playerHash.length() == 0) {
            return false;
        }
        this.profileAge = System.currentTimeMillis() / 1000L;
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("target", playerHash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/minetogether/profile", sendStr, true, true);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(resp);
        if (!this.mediumHash.equals(MineTogetherChat.INSTANCE.ourNick)) {
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IrcHandler.whois(this.mediumHash);
            }, MineTogetherChat.whoIsExecutor);
        }
        if (element.isJsonObject() && (status = (obj = element.getAsJsonObject()).get("status")) != null && status.getAsString().equals("success")) {
            JsonObject profileData = obj.getAsJsonObject("profileData").getAsJsonObject(playerHash);
            this.mediumHash = profileData.getAsJsonObject("chat").getAsJsonObject("hash").get("medium").getAsString();
            this.shortHash = profileData.getAsJsonObject("chat").getAsJsonObject("hash").get("short").getAsString();
            this.longHash = profileData.getAsJsonObject("hash").get("long").getAsString();
            this.display = profileData.get("display").getAsString();
            this.hasAccount = profileData.get("hasAccount").getAsBoolean();
            this.premium = profileData.get("premium").getAsBoolean();
            this.online = profileData.getAsJsonObject("chat").get("online").getAsBoolean();
            this.friendCode = profileData.get("friendCode").getAsString();
            this.userDisplay = "User#" + this.longHash.substring(0, 5);
            if (this.display.length() > 8) {
                this.userDisplay = this.display;
            }
            this.isLoadingProfile = false;
            return true;
        }
        if (this.isFriend()) {
            // empty if block
        }
        this.isLoadingProfile = false;
        return false;
    }
}

