/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.MineTogetherServer;
import net.creeperhost.minetogether.handler.PregenTask;
import net.creeperhost.minetogether.handler.WatchDogHandler;
import net.creeperhost.minetogether.lib.serverorder.Pair;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class PregenHandler {
    public static HashMap<RegistryKey<World>, PregenTask> pregenTasks = new HashMap();
    public static boolean shouldKickPlayer;
    @Nullable
    private static PregenTask activeTask;

    public static void addTask(RegistryKey<World> dimension, int minX, int maxX, int minZ, int maxZ, int chunksPerTick, boolean preventJoin) {
        if (pregenTasks.get(dimension) != null) {
            return;
        }
        pregenTasks.put(dimension, new PregenTask(dimension, minX, maxX, minZ, maxZ, chunksPerTick, preventJoin));
    }

    public static void onWorldTick(MinecraftServer minecraftServer) {
        if (pregenTasks.isEmpty()) {
            return;
        }
        if (pregenTasks.containsKey(ServerWorld.field_234918_g_)) {
            ServerWorld serverLevel = minecraftServer.func_71218_a(ServerWorld.field_234918_g_);
            PregenTask pregenTask = pregenTasks.get(ServerWorld.field_234918_g_);
            if (pregenTask == null) {
                return;
            }
            shouldKickPlayer = pregenTask.preventJoin;
            activeTask = pregenTask;
            if (pregenTask.chunksToGen.isEmpty()) {
                MineTogether.logger.info("No more chunks to generate for dimension " + pregenTask.dimension + " - removing task!");
                pregenTasks.remove(pregenTask.dimension);
                shouldKickPlayer = false;
                activeTask = null;
                if (pregenTasks.isEmpty()) {
                    WatchDogHandler.resuscitateWatchdog();
                }
                PregenHandler.serializePreload();
                return;
            }
            int max = pregenTask.chunksPerTick;
            ArrayList<Pair<Integer, Integer>> chunkToGen = new ArrayList<Pair<Integer, Integer>>();
            int i = 0;
            for (Pair<Integer, Integer> pair : pregenTask.chunksToGen) {
                if (i >= max) break;
                chunkToGen.add(pair);
                ++i;
            }
            long curTime = System.currentTimeMillis();
            if (pregenTask.startTime == 0L) {
                pregenTask.lastCheckedTime = curTime;
                pregenTask.startTime = curTime;
            }
            if (curTime - pregenTask.lastCheckedTime >= 10000L) {
                pregenTask.lastCheckedTime = curTime;
                int lastChunks = pregenTask.lastChunksDone;
                pregenTask.lastChunksDone = pregenTask.chunksDone;
                int n = pregenTask.chunksDone - lastChunks;
                int chunkProgress = PregenHandler.percentage(pregenTask.totalChunks, pregenTask.chunksDone);
                pregenTask.lastPregenString = "Pre-generating chunks for dimension " + pregenTask.dimension.func_240901_a_() + ", current speed " + n + " every 10 seconds.\n" + pregenTask.chunksDone + "/" + pregenTask.totalChunks + " " + PregenHandler.getTimeRemaining(pregenTask) + " remaining :";
                MineTogether.logger.info(pregenTask.lastPregenString);
                long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                double percentage = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / (double)Runtime.getRuntime().totalMemory() * 100.0;
                MineTogether.logger.info("Memory usage " + PregenHandler.formatMemory(usedMemory) + "/" + PregenHandler.formatMemory(Runtime.getRuntime().totalMemory()) + " " + (int)percentage + "%");
                MineTogether.logger.info(pregenTask.lastPregenString);
                if (pregenTask.curChunksPerTick == 0 && serverLevel.func_72863_F().func_73152_e() < pregenTask.chunkLoadCount) {
                    MineTogether.logger.info("Chunks appear to be unloading now - going to tentatively restart the pregen.");
                    pregenTask.curChunksPerTick = 1;
                }
                if (serverLevel.func_72863_F().func_73152_e() >= pregenTask.chunkLoadCount + n * 2 || percentage >= 80.0) {
                    pregenTask.chunkLoadCount = serverLevel.func_72863_F().func_73152_e();
                    --pregenTask.curChunksPerTick;
                    if (percentage >= 80.0) {
                        MineTogether.logger.info("Memory usage too high, Forcing Garbage collection.");
                        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        System.gc();
                        long newUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        long freed = used - newUsed;
                        MineTogether.logger.info("New used memory " + PregenHandler.formatMemory(newUsed) + ", Freed memory " + PregenHandler.formatMemory(freed));
                    }
                    if (pregenTask.curChunksPerTick == 0) {
                        MineTogether.logger.info("Frozen chunk generating as it appears that chunks aren't being unloaded fast enough. Will check the status in another 10 seconds.");
                    }
                } else if (pregenTask.curChunksPerTick < pregenTask.chunksPerTick) {
                    ++pregenTask.curChunksPerTick;
                }
                PregenHandler.serializePreload();
            }
            WatchDogHandler.killWatchDog();
            for (Pair pair : chunkToGen) {
                serverLevel.func_72863_F().func_217205_a(((Integer)pair.getLeft()).intValue(), ((Integer)pair.getRight()).intValue(), true);
                pregenTask.storedCurX = (Integer)pair.getLeft();
                pregenTask.storedCurZ = (Integer)pair.getRight();
                ++pregenTask.chunksDone;
            }
            if (pregenTask.chunksDone != 0 && pregenTask.chunksDone % 1000 == 0) {
                serverLevel.func_72863_F().func_217210_a(true);
            }
            pregenTask.chunksToGen.removeAll(chunkToGen);
        }
    }

    public static void onPlayerJoin(ServerPlayerEntity serverPlayer) {
        if (serverPlayer != null && PregenHandler.isPreGenerating() && shouldKickPlayer) {
            String remainingTime = PregenHandler.getActiveTask() != null ? PregenHandler.getTimeRemaining(PregenHandler.getActiveTask()) : "";
            serverPlayer.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("MineTogether Server is still pre-generating!\n" + remainingTime + " Remaining:" + PregenHandler.getActiveTask().totalChunks + ":" + PregenHandler.getActiveTask().chunksDone));
            MineTogether.logger.error("Kicked player " + serverPlayer.func_200200_C_() + " as still pre-generating");
        }
    }

    public static int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    public static boolean isPreGenerating() {
        return !pregenTasks.isEmpty();
    }

    public static PregenTask getActiveTask() {
        return activeTask;
    }

    public static String getTimeRemaining(PregenTask pregenTask) {
        long curTime = System.currentTimeMillis();
        long deltaTime = curTime - pregenTask.startTime;
        double timePerChunk = (double)deltaTime / (double)pregenTask.chunksDone;
        long chunksRemaining = pregenTask.totalChunks - pregenTask.chunksDone;
        long estimatedTime = (long)((double)chunksRemaining * timePerChunk);
        long days = TimeUnit.MILLISECONDS.toDays(estimatedTime);
        long hours = TimeUnit.MILLISECONDS.toHours(estimatedTime -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(estimatedTime -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(estimatedTime -= TimeUnit.MINUTES.toMillis(minutes));
        return days + " day(s) " + hours + " hour(s) " + minutes + " minute(s) " + seconds + " second(s)";
    }

    private static void serializePreload() {
        FileOutputStream pregenOut = null;
        Type listOfPregenTask = new TypeToken<HashMap<Integer, PregenTask>>(){}.getType();
        try {
            pregenOut = new FileOutputStream(new File(MineTogetherServer.minecraftServer.func_71238_n(), "pregenData.json"));
            Gson gson = new GsonBuilder().create();
            String output = gson.toJson(pregenTasks, listOfPregenTask);
            IOUtils.write((String)output, (OutputStream)pregenOut);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deserializePreload() {
        MineTogether.logger.info("Attempting to load pregenData.json");
        Gson gson = new GsonBuilder().create();
        HashMap output = null;
        Type listOfPregenTask = new TypeToken<HashMap<Integer, PregenTask>>(){}.getType();
        try {
            output = (HashMap)gson.fromJson(IOUtils.toString((URI)new File(MineTogetherServer.minecraftServer.func_71238_n(), "pregenData.json").toURI()), listOfPregenTask);
        }
        catch (Exception exception) {
            // empty catch block
        }
        pregenTasks = output == null ? new HashMap() : output;
        Collection<PregenTask> tasks = pregenTasks.values();
        for (PregenTask task : tasks) {
            task.init();
        }
    }

    private static String formatMemory(long value) {
        long megaByte = 0x100000L;
        long returnValue = value / megaByte;
        return returnValue + " MiB";
    }
}

