/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.StreamUtils;

public class Response
implements Closeable {
    private final int code;
    private final String message;
    private final Map<String, String> headers;
    private String body;
    private InputStream stream;

    private Response(int code, String message, Map<String, String> headers) {
        this.code = code;
        this.message = message;
        this.headers = headers;
    }

    public Response(int code, String message, Map<String, String> headers, InputStream stream) {
        this(code, message, headers);
        this.stream = stream;
    }

    public Response(int code, String message, Map<String, String> headers, String body) {
        this(code, message, headers);
        this.body = body;
    }

    private String parseBodyContents() throws IOException {
        if (this.stream == null) {
            return null;
        }
        this.body = "gzip".equals(this.getHeader("Content-Encoding")) ? StreamUtils.getGzipStreamContents(this.stream) : StreamUtils.getStreamContents(this.stream);
        return this.body;
    }

    public boolean isSuccessful() {
        return this.code >= 200 && this.code < 400;
    }

    public String getBody() throws IOException {
        return this.body == null ? this.parseBodyContents() : this.body;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public String toString() {
        return "Response{code=" + this.code + ", message='" + this.message + '\'' + ", body='" + this.body + '\'' + ", headers=" + this.headers + '}';
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

