/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.model;

import java.util.Objects;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth1Token;

public class OAuth1RequestToken
extends OAuth1Token {
    private static final long serialVersionUID = 6185104114662587991L;
    private final boolean oauthCallbackConfirmed;

    public OAuth1RequestToken(String token, String tokenSecret) {
        this(token, tokenSecret, null);
    }

    public OAuth1RequestToken(String token, String tokenSecret, String rawResponse) {
        this(token, tokenSecret, true, rawResponse);
    }

    public OAuth1RequestToken(String token, String tokenSecret, boolean oauthCallbackConfirmed, String rawResponse) {
        super(token, tokenSecret, rawResponse);
        this.oauthCallbackConfirmed = oauthCallbackConfirmed;
    }

    @Override
    public String getToken() {
        return super.getToken();
    }

    @Override
    public String getTokenSecret() {
        return super.getTokenSecret();
    }

    public boolean isOauthCallbackConfirmed() {
        return this.oauthCallbackConfirmed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.getToken());
        hash = 83 * hash + Objects.hashCode(this.getTokenSecret());
        hash = 83 * hash + (this.oauthCallbackConfirmed ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth1RequestToken other = (OAuth1RequestToken)obj;
        if (this.oauthCallbackConfirmed != other.isOauthCallbackConfirmed()) {
            return false;
        }
        if (!Objects.equals(this.getToken(), other.getToken())) {
            return false;
        }
        return Objects.equals(this.getTokenSecret(), other.getTokenSecret());
    }
}

