/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.irc.IRCServer;

public class Test {
    public static final String nickname = "TravisN";
    public static AtomicBoolean first = new AtomicBoolean(true);
    private static OutputStreamWriter outputStreamWriter;
    private static BufferedWriter bufferedWriter;
    private static Socket socket;
    private static final char CTCP_DELIMITER = '\u0001';
    private static final char CTCP_MQUOTE = '\u0016';
    private static final Pattern CTCP_ESCAPABLE_CHAR;
    private static final Pattern CTCP_ESCAPED_CHAR;
    private static CompletableFuture chatFuture;
    private static String MTHASH;

    public static void main(String[] args) {
        Test.start(ChatCallbacks.getIRCServerDetails());
    }

    public static void start(IRCServer ircServer) {
        try {
            if (chatFuture != null) {
                return;
            }
            socket = new Socket(ircServer.address, ircServer.port);
            outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            chatFuture = CompletableFuture.runAsync(() -> {
                String line = null;
                try {
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.startsWith("PING ")) {
                            Test.sendString("PONG " + line.substring(5) + "\r\n");
                            if (!first.get()) continue;
                            Test.sendString("USER MineTogether 8 * :{\"p\":\"m35\",\"b\":\"MzUxNzQ\\u003d\"}");
                            Test.sendCTPCMessagePrivate(MTHASH, "VERIFY", "1");
                            first.getAndSet(false);
                            continue;
                        }
                        System.out.println(line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Test.sendString("NICK TravisN");
            while (!socket.isClosed()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendCTPCMessagePrivate(String target, String type, String value) {
        Test.sendString("PRIVMSG " + target + " :" + Test.toCtcp(type + " " + value));
    }

    public static String toCtcp(String message) {
        StringBuilder builder = new StringBuilder(message.length());
        builder.append('\u0001');
        int currentIndex = 0;
        Matcher matcher = CTCP_ESCAPABLE_CHAR.matcher(message);
        while (matcher.find()) {
            if (matcher.start() > currentIndex) {
                builder.append(message, currentIndex, matcher.start());
            }
            switch (matcher.group()) {
                case "\n": {
                    builder.append('\u0016').append('n');
                    break;
                }
                case "\r": {
                    builder.append('\u0016').append('r');
                    break;
                }
                case "\u0000": {
                    builder.append('\u0016').append('0');
                    break;
                }
                case "\u0016": {
                    builder.append('\u0016').append('\u0016');
                    break;
                }
                case "\u0001": {
                    builder.append("\\a");
                    break;
                }
                case "\\": {
                    builder.append("\\\\");
                    break;
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex < message.length()) {
            builder.append(message.substring(currentIndex));
        }
        builder.append('\u0001');
        return builder.toString();
    }

    public static void sendString(String str) {
        try {
            bufferedWriter.write(str + "\r\n");
            bufferedWriter.flush();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
    }

    static {
        CTCP_ESCAPABLE_CHAR = Pattern.compile("[\n\r\u0000\u0001\u0016\\\\]");
        CTCP_ESCAPED_CHAR = Pattern.compile("([\u0016\\\\])(.)");
        chatFuture = null;
        MTHASH = "MT6C416B82DFBD050EA2279038E981";
    }
}

