/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.sort;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nullable;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.sort.CyclePresentException;
import net.covers1624.quack.sort.StronglyConnectedComponentDetector;

@Requires(value="com.google.guava:guava")
public final class TopologicalSort {
    public static <T> List<T> topologicalSort(Graph<T> graph, @Nullable Comparator<? super T> comparator) throws IllegalArgumentException {
        Preconditions.checkArgument(graph.isDirected(), "Cannot topologically sort an undirected graph!");
        Preconditions.checkArgument(!graph.allowsSelfLoops(), "Cannot topologically sort a graph with self loops!");
        AbstractCollection queue = comparator == null ? new ArrayDeque() : new PriorityQueue<T>(comparator);
        HashMap<Object, Integer> degrees2 = new HashMap<Object, Integer>();
        ArrayList results = new ArrayList();
        for (T node2 : graph.nodes()) {
            int degree2 = graph.inDegree(node2);
            if (degree2 == 0) {
                queue.add(node2);
                continue;
            }
            degrees2.put(node2, degree2);
        }
        while (!queue.isEmpty()) {
            Object current = queue.remove();
            results.add(current);
            for (Object successor : graph.successors(current)) {
                int updated = degrees2.compute(successor, (node, degree) -> Objects.requireNonNull(degree, () -> "Invalid degree present for " + node) - 1);
                if (updated != 0) continue;
                queue.add(successor);
                degrees2.remove(successor);
            }
        }
        if (!degrees2.isEmpty()) {
            Set<Set<T>> components = new StronglyConnectedComponentDetector<T>(graph).getComponents();
            components.removeIf(set -> set.size() < 2);
            TopologicalSort.throwCyclePresentException(components);
        }
        return results;
    }

    private static <T> void throwCyclePresentException(Set<Set<T>> components) {
        throw new CyclePresentException(components);
    }
}

