/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.items;

import java.util.List;
import javax.annotation.Nullable;
import net.gigabit101.quantumstorage.client.CreativeTabQuantumStorage;
import net.gigabit101.quantumstorage.tiles.TileController;
import net.gigabit101.quantumstorage.tiles.TileQsu;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemHammer
extends Item {
    public ItemHammer() {
        super(new Item.Properties().func_208103_a(Rarity.EPIC).func_200917_a(1).func_200916_a((ItemGroup)CreativeTabQuantumStorage.INSTANCE));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74778_a("mode", "link");
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity.func_225608_bj_()) {
            this.switchMode(stack);
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack hammerStack = context.func_195996_i();
        if (!context.func_195991_k().field_72995_K) {
            TileQsu tileQsu;
            if (this.getMode(hammerStack).equalsIgnoreCase("link")) {
                if (this.isBlockValid(context.func_195991_k(), context.func_195995_a())) {
                    BlockPos blockPos = context.func_195995_a();
                    if (!hammerStack.func_77942_o()) {
                        hammerStack.func_77982_d(new CompoundNBT());
                    }
                    hammerStack.func_77978_p().func_74768_a("X", blockPos.func_177958_n());
                    hammerStack.func_77978_p().func_74768_a("Y", blockPos.func_177956_o());
                    hammerStack.func_77978_p().func_74768_a("Z", blockPos.func_177952_p());
                    context.func_195999_j().func_146105_b((ITextComponent)new StringTextComponent("X :" + blockPos.func_177958_n() + "Y : " + blockPos.func_177956_o() + "Z : " + blockPos.func_177952_p()), true);
                    return ActionResultType.PASS;
                }
                if (context.func_195991_k().func_175625_s(context.func_195995_a()) != null && context.func_195991_k().func_175625_s(context.func_195995_a()) instanceof TileController) {
                    if (!hammerStack.func_77942_o()) {
                        return super.func_195939_a(context);
                    }
                    TileController tileController = (TileController)context.func_195991_k().func_175625_s(context.func_195995_a());
                    BlockPos hammerPos = new BlockPos(hammerStack.func_77978_p().func_74762_e("X"), hammerStack.func_77978_p().func_74762_e("Y"), hammerStack.func_77978_p().func_74762_e("Z"));
                    boolean connected = tileController.connectTileToController(hammerPos);
                    context.func_195999_j().func_146105_b((ITextComponent)new StringTextComponent("Connected: " + connected), true);
                    this.clearConnections(hammerStack);
                    return ActionResultType.PASS;
                }
            } else if (this.getMode(hammerStack).equalsIgnoreCase("lock") && context.func_195991_k().func_175625_s(context.func_195995_a()) instanceof TileQsu && (tileQsu = (TileQsu)context.func_195991_k().func_175625_s(context.func_195995_a())) != null) {
                if (!tileQsu.isLocked) {
                    tileQsu.setLocked(tileQsu);
                    return ActionResultType.PASS;
                }
                tileQsu.setUnlocked(tileQsu);
                return ActionResultType.PASS;
            }
        }
        return super.func_195939_a(context);
    }

    public void clearConnections(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_196083_e("X");
            stack.func_196083_e("Y");
            stack.func_196083_e("Z");
        }
    }

    public String getMode(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemHammer && stack.func_77978_p().func_74781_a("mode") != null) {
            return stack.func_77978_p().func_74779_i("mode");
        }
        return null;
    }

    public void switchMode(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemHammer) {
            String currentMode;
            switch (currentMode = this.getMode(stack)) {
                case "lock": {
                    stack.func_77978_p().func_74778_a("mode", "link");
                    break;
                }
                case "link": {
                    stack.func_77978_p().func_74778_a("mode", "lock");
                }
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74781_a("X") != null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74781_a("mode") != null) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + "Mode: " + TextFormatting.BLUE + this.getMode(stack).toUpperCase()));
            }
            if (stack.func_77978_p().func_74781_a("X") != null) {
                BlockPos pos = new BlockPos(stack.func_77978_p().func_74762_e("X"), stack.func_77978_p().func_74762_e("Y"), stack.func_77978_p().func_74762_e("Z"));
                tooltip.add((ITextComponent)new StringTextComponent("X :" + pos.func_177958_n() + " Y : " + pos.func_177956_o() + " Z : " + pos.func_177952_p()));
            }
        }
        tooltip.add((ITextComponent)new StringTextComponent("Sneak Left-Click to change mode"));
    }

    public boolean isBlockValid(World world, BlockPos pos) {
        return pos != null && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileQsu;
    }
}

