/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.quantumstorage.inventory;

import net.minecraftforge.items.ItemStackHandler;

public class CachingItemHandler
extends ItemStackHandler {
    public int firstAvailable = 0;
    private int lastUsed = -1;

    public CachingItemHandler(int size) {
        super(size);
    }

    protected void onLoad() {
        super.onLoad();
        this.firstAvailable = this.getSlots();
        this.lastUsed = -1;
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).func_190926_b()) {
                this.firstAvailable = Integer.min(this.firstAvailable, i);
                continue;
            }
            this.lastUsed = Integer.max(this.lastUsed, i);
        }
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        int i = slot;
        while (i < this.firstAvailable && i >= 0 && this.getStackInSlot(i).func_190926_b()) {
            this.firstAvailable = i--;
        }
        for (i = slot; i == this.firstAvailable && i < this.getSlots() && !this.getStackInSlot(i).func_190926_b(); ++i) {
            this.firstAvailable = i + 1;
        }
        i = slot;
        while (i > this.lastUsed && i < this.getSlots() && !this.getStackInSlot(i).func_190926_b()) {
            this.lastUsed = i++;
        }
        for (i = slot; i == this.lastUsed && i >= 0 && this.getStackInSlot(i).func_190926_b(); --i) {
            this.lastUsed = i - 1;
        }
    }

    public int getFirstAvailable() {
        return this.firstAvailable;
    }

    public int getLastUsed() {
        return this.lastUsed;
    }

    public boolean isEmpty() {
        return this.lastUsed == -1;
    }

    public boolean isFull() {
        return this.firstAvailable == this.getSlots();
    }
}

