/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.ItemUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class CompassSearchPacket {
    private ResourceLocation biomeKey;
    private int x;
    private int y;
    private int z;

    public CompassSearchPacket() {
    }

    public CompassSearchPacket(ResourceLocation biomeKey, BlockPos pos) {
        this.biomeKey = biomeKey;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public CompassSearchPacket(PacketBuffer buf) {
        this.biomeKey = buf.func_192575_l();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.biomeKey);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ItemUtils.getHeldNatureCompass((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
            if (!stack.func_190926_b()) {
                NaturesCompassItem natureCompass = (NaturesCompassItem)stack.func_77973_b();
                World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
                natureCompass.searchForBiome(world, (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.biomeKey, new BlockPos(this.x, this.y, this.z), stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

