/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.tile;

import com.buuz135.portality.proxy.CommonProxy;
import com.buuz135.portality.tile.ModuleTile;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyModuleTile
extends ModuleTile<EnergyModuleTile> {
    @Save
    private final EnergyStorageComponent<EnergyModuleTile> energyStorage;
    private final LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.of(this::getEnergyStorage);

    public EnergyModuleTile() {
        super(CommonProxy.BLOCK_CAPABILITY_ENERGY_MODULE);
        this.energyStorage = new EnergyStorageComponent(10000, 10000, 10000, 10, 20);
        this.energyStorage.setComponentHarness((IComponentHarness)this.getSelf());
        this.addGuiAddonFactory(() -> new EnergyBarScreenAddon(10, 20, this.energyStorage));
    }

    @Nonnull
    public EnergyStorageComponent<EnergyModuleTile> getEnergyStorage() {
        return this.energyStorage;
    }

    @Nonnull
    public LazyOptional getCapability(@Nonnull Capability cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        if (!this.isInput()) {
            for (Direction facing : Direction.values()) {
                BlockPos checking = this.field_174879_c.func_177972_a(facing);
                TileEntity checkingTile = this.field_145850_b.func_175625_s(checking);
                if (checkingTile == null) continue;
                checkingTile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()).ifPresent(storage -> {
                    int energy = storage.receiveEnergy(Math.min(this.energyStorage.getEnergyStored(), 1000), false);
                    if (energy > 0) {
                        this.energyStorage.extractEnergy(energy, false);
                        return;
                    }
                });
            }
        }
    }

    @Nonnull
    public EnergyModuleTile getSelf() {
        return this;
    }
}

