/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.tile.TileDungeonController;
import wayoftime.bloodmagic.tile.base.TileBase;

public class TileDungeonSeal
extends TileBase {
    @ObjectHolder(value="bloodmagic:dungeon_seal")
    public static TileEntityType<TileDungeonSeal> TYPE;
    public BlockPos controllerPos = BlockPos.field_177992_a;
    public BlockPos doorPos = BlockPos.field_177992_a;
    public Direction doorDirection = Direction.NORTH;
    public String doorType = "";
    public List<ResourceLocation> potentialRoomTypes = new ArrayList<ResourceLocation>();

    public TileDungeonSeal(TileEntityType<?> type) {
        super(type);
    }

    public TileDungeonSeal() {
        this(TYPE);
    }

    public int requestRoomFromController(ItemStack heldStack) {
        TileDungeonController tileController;
        int state;
        TileEntity tile;
        if (this.field_145850_b.field_72995_K || this.potentialRoomTypes.isEmpty() || !((tile = this.field_145850_b.func_175625_s(this.controllerPos)) instanceof TileDungeonController) || (state = (tileController = (TileDungeonController)tile).handleRequestForRoomPlacement(heldStack, this.doorPos, this.doorDirection, this.doorType, this.potentialRoomTypes)) == -1) {
            // empty if block
        }
        return 3;
    }

    public void acceptDoorInformation(BlockPos controllerPos, BlockPos doorPos, Direction doorDirection, String doorType, List<ResourceLocation> potentialRoomTypes) {
        this.controllerPos = controllerPos;
        this.doorPos = doorPos;
        this.doorDirection = doorDirection;
        this.doorType = doorType;
        this.potentialRoomTypes = potentialRoomTypes;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        CompoundNBT masterTag = tag.func_74775_l("dungeon_controller");
        this.controllerPos = new BlockPos(masterTag.func_74762_e("xCoord"), masterTag.func_74762_e("yCoord"), masterTag.func_74762_e("zCoord"));
        CompoundNBT doorTag = tag.func_74775_l("dungeon_door");
        this.doorPos = new BlockPos(doorTag.func_74762_e("xCoord"), doorTag.func_74762_e("yCoord"), doorTag.func_74762_e("zCoord"));
        int dir = tag.func_74762_e("direction");
        if (dir == 0) {
            this.doorDirection = Direction.NORTH;
        }
        this.doorDirection = Direction.values()[tag.func_74762_e("direction")];
        ListNBT listnbt = tag.func_150295_c("door_types", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            String str = compoundnbt.func_74779_i("door");
            this.potentialRoomTypes.add(new ResourceLocation(str));
        }
        this.doorType = tag.func_74779_i("type");
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        CompoundNBT masterTag = new CompoundNBT();
        masterTag.func_74768_a("xCoord", this.controllerPos.func_177958_n());
        masterTag.func_74768_a("yCoord", this.controllerPos.func_177956_o());
        masterTag.func_74768_a("zCoord", this.controllerPos.func_177952_p());
        tag.func_218657_a("dungeon_controller", (INBT)masterTag);
        CompoundNBT doorTag = new CompoundNBT();
        doorTag.func_74768_a("xCoord", this.doorPos.func_177958_n());
        doorTag.func_74768_a("yCoord", this.doorPos.func_177956_o());
        doorTag.func_74768_a("zCoord", this.doorPos.func_177952_p());
        tag.func_218657_a("dungeon_door", (INBT)doorTag);
        tag.func_74768_a("direction", this.doorDirection.func_176745_a());
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.potentialRoomTypes.size(); ++i) {
            String str = this.potentialRoomTypes.get(i).toString();
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("door", str);
            listnbt.add((Object)compoundnbt);
        }
        if (!listnbt.isEmpty()) {
            tag.func_218657_a("door_types", (INBT)listnbt);
        }
        tag.func_74778_a("type", this.doorType);
        return tag;
    }
}

