/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.item.dungeon.IDungeonKey;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;
import wayoftime.bloodmagic.tile.base.TileBase;

public class TileDungeonController
extends TileBase {
    @ObjectHolder(value="bloodmagic:dungeon_controller")
    public static TileEntityType<TileDungeonController> TYPE;
    private DungeonSynthesizer dungeon = null;

    public TileDungeonController(TileEntityType<?> type) {
        super(type);
    }

    public TileDungeonController() {
        this(TYPE);
    }

    public void setDungeonSynthesizer(DungeonSynthesizer dungeon) {
        this.dungeon = dungeon;
    }

    public int handleRequestForRoomPlacement(ItemStack keyStack, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, List<ResourceLocation> potentialRooms) {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof ServerWorld && !keyStack.func_190926_b() && keyStack.func_77973_b() instanceof IDungeonKey) {
            ResourceLocation roomType = ((IDungeonKey)keyStack.func_77973_b()).getValidResourceLocation(potentialRooms);
            if (roomType == null) {
                return -1;
            }
            int placementState = this.dungeon.addNewRoomToExistingDungeon((ServerWorld)this.field_145850_b, this.func_174877_v(), roomType, this.field_145850_b.field_73012_v, activatedDoorPos, doorFacing, activatedDoorType, potentialRooms);
            if (placementState == 0) {
                keyStack.func_190918_g(1);
                LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_145850_b);
                lightningboltentity.func_70107_b((double)activatedDoorPos.func_177958_n(), (double)activatedDoorPos.func_177956_o(), (double)activatedDoorPos.func_177952_p());
                lightningboltentity.func_233623_a_(true);
                this.field_145850_b.func_217376_c((Entity)lightningboltentity);
            }
            return placementState;
        }
        return -1;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        if (tag.func_74764_b("dungeon_controller")) {
            CompoundNBT synthesizerTag = tag.func_74775_l("dungeon_controller");
            this.dungeon = new DungeonSynthesizer();
            this.dungeon.readFromNBT(synthesizerTag);
        }
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        if (this.dungeon != null) {
            CompoundNBT synthesizerTag = new CompoundNBT();
            this.dungeon.writeToNBT(synthesizerTag);
            tag.func_218657_a("dungeon_controller", (INBT)synthesizerTag);
        }
        return tag;
    }
}

