/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.entity.projectile.EntityBloodLight;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilBloodLight
extends ItemSigilBase {
    public ItemSigilBloodLight() {
        super("bloodlight", 10);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.getCooldownRemainder(stack) > 0) {
            this.reduceCooldown(stack);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        BlockRayTraceResult mop = ItemSigilBloodLight.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (this.getCooldownRemainder(stack) > 0) {
            return super.func_77659_a(world, player, hand);
        }
        if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTrace = mop;
            BlockPos blockPos = blockRayTrace.func_216350_a().func_177972_a(blockRayTrace.func_216354_b());
            if (world.func_175623_d(blockPos)) {
                world.func_175656_a(blockPos, ((Block)BloodMagicBlocks.BLOOD_LIGHT.get()).func_176223_P());
                if (!world.field_72995_K) {
                    SoulNetwork network = NetworkHelper.getSoulNetwork(this.getBinding(stack));
                    network.syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, this.getLpUsed()));
                }
                this.resetCooldown(stack);
                player.func_184609_a(hand);
                return super.func_77659_a(world, player, hand);
            }
        } else {
            if (!world.field_72995_K) {
                SoulNetwork network = NetworkHelper.getSoulNetwork(this.getBinding(stack));
                EntityBloodLight light = new EntityBloodLight(world, (LivingEntity)player);
                light.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                world.func_217376_c((Entity)light);
                network.syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, this.getLpUsed()));
            }
            this.resetCooldown(stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public int getCooldownRemainder(ItemStack stack) {
        return NBTHelper.checkNBT(stack).func_77978_p().func_74762_e("ticksRemaining");
    }

    public void reduceCooldown(ItemStack stack) {
        NBTHelper.checkNBT(stack).func_77978_p().func_74768_a("ticksRemaining", this.getCooldownRemainder(stack) - 1);
    }

    public void resetCooldown(ItemStack stack) {
        NBTHelper.checkNBT(stack).func_77978_p().func_74768_a("ticksRemaining", 10);
    }
}

