/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wayoftime.bloodmagic.tile.TileMimic;

public class ItemBlockMimic
extends BlockItem {
    public ItemBlockMimic(Block block, Item.Properties prop) {
        super(block, prop);
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        if (!player.func_225608_bj_()) {
            return super.func_195942_a(context);
        }
        BlockPos pos = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        World world = context.func_195991_k();
        Direction direction = context.func_196000_l();
        if (player.func_175151_a(pos, direction, stack)) {
            BlockState replacedBlockstate = world.func_180495_p(pos);
            Block replacedBlock = replacedBlockstate.func_177230_c();
            ItemStack replacedStack = replacedBlock.func_185473_a((IBlockReader)world, pos, replacedBlockstate);
            BlockState mimicBlockstate = this.func_179223_d().func_176223_P();
            if (!this.canReplaceBlock(world, pos, replacedBlockstate)) {
                return super.func_195942_a(context);
            }
            TileEntity tileReplaced = world.func_175625_s(pos);
            if (!this.canReplaceTile(tileReplaced)) {
                return ActionResultType.FAIL;
            }
            CompoundNBT tileTag = this.getTagFromTileEntity(tileReplaced);
            if (tileReplaced != null) {
                CompoundNBT voidTag = new CompoundNBT();
                voidTag.func_74768_a("x", pos.func_177958_n());
                voidTag.func_74768_a("y", pos.func_177956_o());
                voidTag.func_74768_a("z", pos.func_177952_p());
                tileReplaced.deserializeNBT(voidTag);
            }
            stack.func_190918_g(1);
            world.func_180501_a(pos, mimicBlockstate, 3);
            SoundType soundtype = mimicBlockstate.getSoundType((IWorldReader)world, pos, (Entity)context.func_195999_j());
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileMimic) {
                TileMimic mimic = (TileMimic)tile;
                mimic.tileTag = tileTag;
                mimic.setMimic(replacedBlockstate);
                mimic.func_70299_a(0, replacedStack);
                mimic.refreshTileEntity();
                if (player.func_184812_l_()) {
                    mimic.dropItemsOnBreak = false;
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean canReplaceTile(TileEntity tile) {
        if (tile instanceof ChestTileEntity) {
            return true;
        }
        return tile == null;
    }

    public boolean canReplaceBlock(World world, BlockPos pos, BlockState state) {
        return state.func_185887_b((IBlockReader)world, pos) != -1.0f;
    }

    public CompoundNBT getTagFromTileEntity(TileEntity tile) {
        CompoundNBT tag = new CompoundNBT();
        if (tile != null) {
            return tile.func_189515_b(tag);
        }
        return tag;
    }
}

