/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.tileentity;

import cofh.core.tileentity.TileCoFH;
import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.ITransferControllableTile;
import cofh.core.util.control.ReconfigControlModule;
import cofh.core.util.control.ReconfigControlModuleLimited;
import cofh.core.util.control.TransferControlModule;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.IReconfigurable;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.tileentity.ThermalTileBase;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.ModelDataManager;

public abstract class CellTileBase
extends ThermalTileBase
implements IReconfigurableTile,
ITransferControllableTile {
    protected int compareTracker;
    protected int levelTracker;
    protected int inputTracker;
    protected int outputTracker;
    public int amountInput;
    public int amountOutput;
    protected int prevLight;
    protected ReconfigControlModule reconfigControl = new ReconfigControlModuleLimited((IReconfigurableTile)this);
    protected TransferControlModule transferControl = new TransferControlModule((ITransferControllableTile)this);

    public CellTileBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TileCoFH worldContext(BlockState state, IBlockReader world) {
        this.reconfigControl.setFacing((Direction)state.func_177229_b((Property)Constants.FACING_HORIZONTAL));
        this.updateHandlers();
        return this;
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateSideCache();
    }

    @Override
    public ItemStack createItemStackTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
        nbt.func_74768_a("AmountIn", this.amountInput);
        nbt.func_74768_a("AmountOut", this.amountOutput);
        return super.createItemStackTag(stack);
    }

    public abstract int getMaxInput();

    public abstract int getMaxOutput();

    protected void updateSideCache() {
        Direction curFacing;
        Direction prevFacing = this.getFacing();
        if (prevFacing != (curFacing = (Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_HORIZONTAL))) {
            this.reconfigControl.setFacing(curFacing);
            int iPrev = prevFacing.func_176745_a();
            int iFace = curFacing.func_176745_a();
            IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[6];
            if (iPrev == BlockHelper.SIDE_RIGHT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_CLOCK_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_LEFT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_COUNTER_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_OPPOSITE[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.INVERT_AROUND_Y[i]];
                }
            }
            this.reconfigControl.setSideConfig(sides);
        }
        this.updateHandlers();
    }

    protected abstract void updateTrackers(boolean var1);

    public int getLevelTracker() {
        return this.levelTracker;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    public PacketBuffer getConfigPacket(PacketBuffer buffer) {
        super.getConfigPacket(buffer);
        buffer.writeInt(this.amountInput);
        buffer.writeInt(this.amountOutput);
        return buffer;
    }

    public void handleConfigPacket(PacketBuffer buffer) {
        super.handleConfigPacket(buffer);
        this.amountInput = MathHelper.clamp((int)buffer.readInt(), (int)0, (int)this.getMaxInput());
        this.amountOutput = MathHelper.clamp((int)buffer.readInt(), (int)0, (int)this.getMaxOutput());
    }

    @Override
    public PacketBuffer getControlPacket(PacketBuffer buffer) {
        super.getControlPacket(buffer);
        this.reconfigControl.writeToBuffer(buffer);
        this.transferControl.writeToBuffer(buffer);
        buffer.writeInt(this.compareTracker);
        buffer.writeInt(this.levelTracker);
        return buffer;
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        this.reconfigControl.readFromBuffer(buffer);
        this.transferControl.readFromBuffer(buffer);
        this.compareTracker = buffer.readInt();
        this.levelTracker = buffer.readInt();
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.amountInput);
        buffer.writeInt(this.amountOutput);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.amountInput = buffer.readInt();
        this.amountOutput = buffer.readInt();
    }

    @Override
    public PacketBuffer getStatePacket(PacketBuffer buffer) {
        super.getStatePacket(buffer);
        buffer.writeInt(this.compareTracker);
        buffer.writeInt(this.levelTracker);
        buffer.writeInt(this.prevLight);
        return buffer;
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        this.compareTracker = buffer.readInt();
        this.levelTracker = buffer.readInt();
        this.prevLight = buffer.readInt();
        if (this.prevLight != this.getLightValue()) {
            this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
        }
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.reconfigControl.setFacing(Direction.func_82600_a((int)nbt.func_74771_c("Facing")));
        this.reconfigControl.read(nbt);
        this.transferControl.read(nbt);
        this.amountInput = nbt.func_74762_e("AmountIn");
        this.amountOutput = nbt.func_74762_e("AmountOut");
        this.updateTrackers(false);
        this.updateHandlers();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Facing", (byte)this.reconfigControl.getFacing().func_176745_a());
        this.reconfigControl.write(nbt);
        this.transferControl.write(nbt);
        nbt.func_74768_a("AmountIn", this.amountInput);
        nbt.func_74768_a("AmountOut", this.amountOutput);
        return nbt;
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.amountInput = MathHelper.clamp((int)this.amountInput, (int)0, (int)this.getMaxInput());
        this.amountOutput = MathHelper.clamp((int)this.amountOutput, (int)0, (int)this.getMaxOutput());
    }

    public ReconfigControlModule reconfigControl() {
        return this.reconfigControl;
    }

    public TransferControlModule transferControl() {
        return this.transferControl;
    }

    @Override
    public void onControlUpdate() {
        this.updateTrackers(false);
        super.onControlUpdate();
    }

    @Override
    public void readConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.reconfigControl.readSettings(tag);
        this.transferControl.readSettings(tag);
        super.readConveyableData(player, tag);
    }

    @Override
    public void writeConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.reconfigControl.writeSettings(tag);
        this.transferControl.writeSettings(tag);
        super.writeConveyableData(player, tag);
    }
}

