/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.IFluidStackAccess;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.util.ComparableItemStack;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.BottlerRecipe;
import cofh.thermal.core.util.recipes.machine.BottlerRecipeNBT;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BottlerRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final BottlerRecipeManager INSTANCE = new BottlerRecipeManager();
    protected static final int DEFAULT_ENERGY = 400;
    protected static boolean defaultBucketRecipes = true;
    protected static boolean defaultPotionRecipes = true;
    protected Map<List<Integer>, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 0;
    protected List<BottlerRecipe> convertedRecipes = new ArrayList<BottlerRecipe>();

    public static BottlerRecipeManager instance() {
        return INSTANCE;
    }

    private BottlerRecipeManager() {
        super(400);
    }

    public void addRecipe(ThermalRecipe recipe) {
        if (!recipe.getInputItems().isEmpty()) {
            for (ItemStack recipeInput : recipe.getInputItems().get(0).func_193365_a()) {
                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(recipeInput), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
            }
        } else {
            this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.emptyList(), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(BottlerRecipeManager.convert(item));
    }

    public boolean validFluid(FluidStack fluid) {
        return this.validFluids.contains(fluid.getFluid());
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validFluids.clear();
        this.validItems.clear();
        this.convertedRecipes.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty() && inputTanks.isEmpty() || inputSlots.get(0).isEmpty() && inputTanks.get(0).isEmpty()) {
            return null;
        }
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            ItemStack inputItem = inputSlots.get(0).getItemStack();
            return this.recipeMap.get(Collections.singletonList(BottlerRecipeManager.convert(inputItem).hashCode()));
        }
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty()) {
            FluidStack inputFluid = inputTanks.get(0).getFluidStack();
            return this.recipeMap.get(Collections.singletonList(FluidHelper.fluidHashcodeNoTag((FluidStack)inputFluid)));
        }
        ItemStack inputItem = inputSlots.get(0).getItemStack();
        FluidStack inputFluid = inputTanks.get(0).getFluidStack();
        return this.recipeMap.get(Arrays.asList(BottlerRecipeManager.convert(inputItem).hashCode(), FluidHelper.fluidHashcodeNoTag((FluidStack)inputFluid)));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || inputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack inputItem = inputItems.get(0);
        if (inputItem.func_190926_b()) {
            return null;
        }
        FluidStack inputFluid = inputFluids.get(0);
        if (inputFluid.isEmpty()) {
            return null;
        }
        for (ItemStack stack : outputItems) {
            if (!stack.func_190926_b()) continue;
            return null;
        }
        this.validItems.add(BottlerRecipeManager.convert(inputItem));
        this.validFluids.add(inputFluid.getFluid());
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(Arrays.asList(BottlerRecipeManager.convert(inputItem).hashCode(), FluidHelper.fluidHashcodeNoTag((FluidStack)inputFluid)), recipe);
        return recipe;
    }

    protected IMachineRecipe addRecipe(IMachineRecipe recipe) {
        ItemStack inputItem = recipe.getInputItems().get(0);
        if (inputItem.func_190926_b()) {
            return null;
        }
        FluidStack inputFluid = recipe.getInputFluids().get(0);
        if (inputFluid.isEmpty()) {
            return null;
        }
        this.validItems.add(BottlerRecipeManager.convert(inputItem));
        this.validFluids.add(inputFluid.getFluid());
        this.recipeMap.put(Arrays.asList(BottlerRecipeManager.convert(inputItem).hashCode(), FluidHelper.fluidHashcodeNoTag((FluidStack)inputFluid)), recipe);
        return recipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        int energy = (int)((float)this.getDefaultEnergy() * this.getDefaultScale());
        if (defaultBucketRecipes) {
            ThermalCore.LOG.debug("Adding default Bucket recipes to the Fluid Encapsulator...");
            ObjectOpenHashSet bucketFluids = new ObjectOpenHashSet(32);
            for (Fluid fluid : ForgeRegistries.FLUIDS) {
                if (!(fluid instanceof FlowingFluid)) continue;
                Fluid still = ((FlowingFluid)fluid).func_210198_f();
                if (still == null) {
                    ThermalCore.LOG.error("Fluid " + fluid.getRegistryName() + " returned a null value for its Still Fluid! This is an error. Report this to the mod author. Probable mod: " + fluid.getRegistryName().func_110624_b());
                    continue;
                }
                ItemStack bucket = new ItemStack((IItemProvider)still.func_204524_b());
                if (bucket.func_190926_b() || bucketFluids.contains(still)) continue;
                this.addRecipe(this.convert(energy, 0.0f, new ItemStack((IItemProvider)Items.field_151133_ar), new FluidStack(still, 1000), bucket));
                bucketFluids.add(still);
            }
        }
        if (defaultPotionRecipes) {
            ThermalCore.LOG.debug("Adding default Potion recipes to the Fluid Encapsulator...");
            this.addRecipe(this.convert(energy, 0.0f, new ItemStack((IItemProvider)Items.field_151069_bo), new FluidStack((Fluid)CoreReferences.FLUID_POTION, 250), new ItemStack((IItemProvider)Items.field_151068_bn)));
        }
        Map recipes = recipeManager.func_215366_a(TCoreRecipeTypes.RECIPE_BOTTLER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
    }

    public List<BottlerRecipe> getConvertedRecipes() {
        return this.convertedRecipes;
    }

    protected BottlerRecipeNBT convert(int energy, float experience, @Nonnull ItemStack inputItem, @Nonnull FluidStack inputFluid, @Nonnull ItemStack outputItem) {
        this.convertedRecipes.add(new BottlerRecipe(new ResourceLocation("thermal", "bottler_" + inputItem.func_77973_b().getRegistryName().func_110623_a()), energy, experience, Collections.singletonList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{inputItem})), Collections.singletonList(inputFluid), Collections.singletonList(outputItem), Collections.emptyList(), Collections.emptyList()));
        return new BottlerRecipeNBT(energy, experience, inputItem, inputFluid, outputItem);
    }
}

