/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util;

import cofh.core.item.BlockItemAugmentable;
import cofh.core.item.BlockItemCoFH;
import cofh.core.item.BlockNamedItemCoFH;
import cofh.core.item.CoinItem;
import cofh.core.item.CountedItem;
import cofh.core.item.ExcavatorItem;
import cofh.core.item.HammerItem;
import cofh.core.item.ItemCoFH;
import cofh.core.item.SickleItem;
import cofh.lib.block.impl.crops.CropsBlockCoFH;
import cofh.lib.block.impl.crops.CropsBlockPerennial;
import cofh.lib.block.impl.crops.CropsBlockTall;
import cofh.lib.item.impl.BowItemCoFH;
import cofh.lib.item.impl.FishingRodItemCoFH;
import cofh.lib.item.impl.ShearsItemCoFH;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalItemGroups;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Food;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.Rarity;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.RegistryObject;

public class RegistrationHelper {
    public static void registerBlock(String name, Supplier<Block> sup) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, Rarity.COMMON, Constants.TRUE);
    }

    public static void registerBlock(String name, Supplier<Block> sup, BooleanSupplier showInGroups) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, Rarity.COMMON, showInGroups);
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, rarity, Constants.TRUE);
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, rarity, showInGroups);
    }

    public static void registerBlock(String name, Supplier<Block> sup, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerBlockAndItem(name, sup, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get(name), new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
    }

    public static void registerBlockOnly(String name, Supplier<Block> sup) {
        ThermalCore.BLOCKS.register(name, sup);
    }

    public static void registerBlockAndItem(String name, Supplier<Block> blockSup, Supplier<Item> itemSup) {
        ThermalCore.BLOCKS.register(name, blockSup);
        ThermalCore.ITEMS.register(name, itemSup);
    }

    public static void registerAugBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment) {
        RegistrationHelper.registerAugBlock(name, sup, numSlots, validAugment, ThermalItemGroups.THERMAL_BLOCKS, Rarity.COMMON, Constants.TRUE);
    }

    public static void registerAugBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, BooleanSupplier showInGroups) {
        RegistrationHelper.registerAugBlock(name, sup, numSlots, validAugment, ThermalItemGroups.THERMAL_BLOCKS, Rarity.COMMON, showInGroups);
    }

    public static void registerAugBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        ThermalCore.BLOCKS.register(name, sup);
        ThermalCore.ITEMS.register(name, () -> new BlockItemAugmentable((Block)ThermalCore.BLOCKS.get(name), new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setNumSlots(numSlots).setAugValidator(validAugment).setShowInGroups(showInGroups));
    }

    public static RegistryObject<Item> registerItem(String name, Supplier<Item> sup) {
        return ThermalCore.ITEMS.register(name, sup);
    }

    public static RegistryObject<Item> registerItem(String name, ItemGroup group) {
        return RegistrationHelper.registerItem(name, group, Rarity.COMMON);
    }

    public static RegistryObject<Item> registerItem(String name, ItemGroup group, Rarity rarity) {
        return RegistrationHelper.registerItem(name, () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)));
    }

    public static void registerMetalSet(String prefix, ItemGroup group, Rarity rarity) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, Constants.TRUE, false, false);
    }

    public static void registerMetalSet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, showInGroups, false, false);
    }

    public static void registerMetalSet(String prefix, ItemGroup group, BooleanSupplier showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, showInGroups, false, false);
    }

    public static void registerAlloySet(String prefix, ItemGroup group, Rarity rarity) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, Constants.TRUE, false, true);
    }

    public static void registerAlloySet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, showInGroups, false, true);
    }

    public static void registerAlloySet(String prefix, ItemGroup group, BooleanSupplier showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, showInGroups, false, true);
    }

    public static void registerVanillaMetalSet(String prefix, ItemGroup group) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, Constants.TRUE, true, false);
    }

    public static void registerMetalSet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups, boolean vanilla, boolean alloy) {
        if (!vanilla) {
            ThermalCore.ITEMS.register(prefix + "_ingot", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
            ThermalCore.ITEMS.register(prefix + "_nugget", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        }
        ThermalCore.ITEMS.register(prefix + "_dust", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        ThermalCore.ITEMS.register(prefix + "_gear", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        ThermalCore.ITEMS.register(prefix + "_plate", () -> new CountedItem(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(() -> ThermalFlags.getFlag(ThermalFlags.FLAG_PLATES).getAsBoolean() && showInGroups.getAsBoolean()));
        ThermalCore.ITEMS.register(prefix + "_coin", () -> new CoinItem(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(() -> ThermalFlags.getFlag(ThermalFlags.FLAG_COINS).getAsBoolean() && showInGroups.getAsBoolean()));
    }

    public static void registerGemSet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerGemSet(prefix, group, rarity, showInGroups, false);
    }

    public static void registerGemSet(String prefix, ItemGroup group, BooleanSupplier showInGroups) {
        RegistrationHelper.registerGemSet(prefix, group, Rarity.COMMON, showInGroups, false);
    }

    public static void registerVanillaGemSet(String prefix, ItemGroup group) {
        RegistrationHelper.registerGemSet(prefix, group, Rarity.COMMON, Constants.TRUE, true);
    }

    public static void registerGemSet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups, boolean vanilla) {
        if (!vanilla) {
            ThermalCore.ITEMS.register(prefix, () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        }
        ThermalCore.ITEMS.register(prefix + "_dust", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        ThermalCore.ITEMS.register(prefix + "_gear", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
    }

    public static void registerStandardToolSet(String prefix, IItemTier tier, ItemGroup toolGroup, ItemGroup combatGroup) {
        ThermalCore.ITEMS.register(prefix + "_shovel", () -> new ShovelItem(tier, 1.5f, -3.0f, new Item.Properties().func_200916_a(toolGroup)));
        ThermalCore.ITEMS.register(prefix + "_pickaxe", () -> new PickaxeItem(tier, 1, -2.8f, new Item.Properties().func_200916_a(toolGroup)));
        ThermalCore.ITEMS.register(prefix + "_axe", () -> new AxeItem(tier, tier.func_200929_c() > 0.0f ? 8.0f - tier.func_200929_c() : 6.0f, MathHelper.clamp((float)(-3.7f + tier.func_200928_b() / 10.0f), (float)-3.2f, (float)-3.0f), new Item.Properties().func_200916_a(toolGroup)));
        ThermalCore.ITEMS.register(prefix + "_hoe", () -> new HoeItem(tier, -tier.func_200925_d(), Math.min(-3.0f + (float)tier.func_200925_d(), 0.0f), new Item.Properties().func_200916_a(toolGroup)));
        ThermalCore.ITEMS.register(prefix + "_sword", () -> new SwordItem(tier, 3, -2.4f, new Item.Properties().func_200916_a(combatGroup)));
    }

    public static void registerExtraToolSet(String prefix, IItemTier tier, ItemGroup toolGroup) {
        ThermalCore.ITEMS.register(prefix + "_excavator", () -> new ExcavatorItem(tier, new Item.Properties().func_200916_a(toolGroup)));
        ThermalCore.ITEMS.register(prefix + "_hammer", () -> new HammerItem(tier, new Item.Properties().func_200916_a(toolGroup)));
        ThermalCore.ITEMS.register(prefix + "_sickle", () -> new SickleItem(tier, new Item.Properties().func_200916_a(toolGroup)));
    }

    public static void registerSpecial(String prefix, IItemTier tier, ItemGroup toolGroup) {
        ThermalCore.ITEMS.register(prefix + "_shears", () -> new ShearsItemCoFH(tier, new Item.Properties().func_200916_a(toolGroup)));
        ThermalCore.ITEMS.register(prefix + "_bow", () -> new BowItemCoFH(tier, new Item.Properties().func_200916_a(toolGroup)));
        ThermalCore.ITEMS.register(prefix + "_fishing_rod", () -> new FishingRodItemCoFH(tier, new Item.Properties().func_200916_a(toolGroup)));
    }

    public static void registerAnnual(String id) {
        ThermalCore.BLOCKS.register(id, () -> new CropsBlockCoFH(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222472_s)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerTallAnnual(String id) {
        ThermalCore.BLOCKS.register(id, () -> new CropsBlockTall(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222472_s)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerPerennial(String id) {
        RegistrationHelper.registerPerennial(id, 7);
    }

    public static void registerPerennial(String id, int postHarvestAge) {
        ThermalCore.BLOCKS.register(id, () -> new CropsBlockPerennial(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222472_s)).postHarvestAge(postHarvestAge).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerCropAndSeed(String id) {
        RegistrationHelper.registerCropAndSeed(id, ThermalItemGroups.THERMAL_ITEMS);
    }

    public static void registerCropAndSeed(String id, Food food) {
        RegistrationHelper.registerCropAndSeed(id, ThermalItemGroups.THERMAL_ITEMS, food);
    }

    public static void registerCropAndSeed(String id, ItemGroup group) {
        RegistrationHelper.registerCropAndSeed(id, group, null);
    }

    public static void registerCropAndSeed(String id, ItemGroup group, Food food) {
        if (food != null) {
            ThermalCore.ITEMS.register(id, () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_221540_a(food)));
        } else {
            ThermalCore.ITEMS.register(id, () -> new ItemCoFH(new Item.Properties().func_200916_a(group)));
        }
        ThermalCore.ITEMS.register(RegistrationHelper.seeds(id), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get(id), new Item.Properties().func_200916_a(group)));
    }

    public static void registerSpores(String id) {
        RegistrationHelper.registerSpores(id, ThermalItemGroups.THERMAL_ITEMS);
    }

    public static void registerSpores(String id, ItemGroup group) {
        ThermalCore.ITEMS.register(RegistrationHelper.spores(id), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get(id), new Item.Properties().func_200916_a(group)));
    }

    public static String deepslate(String id) {
        return "deepslate_" + id;
    }

    public static String block(String id) {
        return id + "_block";
    }

    public static String seeds(String id) {
        return id + "_seeds";
    }

    public static String spores(String id) {
        return id + "_spores";
    }

    public static void registerSound(String soundID) {
        ThermalCore.SOUND_EVENTS.register(soundID, () -> new SoundEvent(new ResourceLocation(soundID)));
    }

    private static /* synthetic */ ItemCoFH lambda$registerMetalSet$3(ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        return new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups);
    }
}

