/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.playerprops.FavoriteDestinationsProperties;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TeleportDestinations
extends AbstractWorldData<TeleportDestinations> {
    private static final String TPDESTINATIONS_NAME = "TPDestinations";
    private final Map<GlobalPos, TeleportDestination> destinations = new HashMap<GlobalPos, TeleportDestination>();
    private final Map<Integer, GlobalPos> destinationById = new HashMap<Integer, GlobalPos>();
    private final Map<GlobalPos, Integer> destinationIdByCoordinate = new HashMap<GlobalPos, Integer>();
    private int lastId = 0;

    public TeleportDestinations() {
        super(TPDESTINATIONS_NAME);
    }

    public static String getDestinationName(TeleportDestinations destinations, int receiverId) {
        String name;
        GlobalPos coordinate = destinations.getCoordinateForId(receiverId);
        if (coordinate == null) {
            name = "?";
        } else {
            TeleportDestination destination = destinations.getDestination(coordinate);
            if (destination == null) {
                name = "?";
            } else {
                name = destination.getName();
                if (name == null || name.isEmpty()) {
                    name = BlockPosTools.toString((BlockPos)destination.getCoordinate()) + " (" + destination.getDimension().func_240901_a_().func_110623_a() + ")";
                }
            }
        }
        return name;
    }

    public void cleanupInvalid() {
        HashSet<GlobalPos> keys = new HashSet<GlobalPos>(this.destinations.keySet());
        for (GlobalPos key : keys) {
            ServerWorld transWorld = LevelTools.getLevel((RegistryKey)key.func_239646_a_());
            boolean removed = false;
            if (transWorld == null) {
                Logging.log((String)("Receiver on dimension " + key.func_239646_a_().func_240901_a_().func_110623_a() + " removed because world can't be loaded!"));
                removed = true;
            } else {
                TileEntity te;
                BlockPos c = key.func_218180_b();
                try {
                    te = transWorld.func_175625_s(c);
                }
                catch (Exception e) {
                    te = null;
                }
                if (!(te instanceof MatterReceiverTileEntity)) {
                    Logging.log((String)("Receiver at " + c + " on dimension " + key.func_239646_a_().func_240901_a_().func_110623_a() + " removed because there is no receiver there!"));
                    removed = true;
                }
            }
            if (!removed) continue;
            this.destinations.remove(key);
        }
    }

    public static TeleportDestinations get(World world) {
        return (TeleportDestinations)TeleportDestinations.getData((World)world, TeleportDestinations::new, (String)TPDESTINATIONS_NAME);
    }

    public Collection<TeleportDestinationClientInfo> getValidDestinations(World worldObj, UUID player) {
        FavoriteDestinationsProperties properties = null;
        if (player != null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            List list = server.func_184103_al().func_181057_v();
            for (ServerPlayerEntity entity : list) {
                if (!player.equals(entity.func_110124_au())) continue;
                properties = PlayerExtendedProperties.getFavoriteDestinations((PlayerEntity)entity).map(h -> h).orElse(null);
                break;
            }
        }
        ArrayList<TeleportDestinationClientInfo> result = new ArrayList<TeleportDestinationClientInfo>();
        for (TeleportDestination destination : this.destinations.values()) {
            TileEntity te;
            TeleportDestinationClientInfo destinationClientInfo = new TeleportDestinationClientInfo(destination);
            BlockPos c = destination.getCoordinate();
            ServerWorld world = LevelTools.getLevel(destination.getDimension());
            String dimName = "<Unknown>";
            if (world != null) {
                dimName = world.func_234923_W_().func_240901_a_().func_110623_a();
            }
            destinationClientInfo.setDimensionName(dimName);
            if (world != null && (te = world.func_175625_s(c)) instanceof MatterReceiverTileEntity) {
                MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
                if (player != null && !matterReceiverTileEntity.checkAccess(player)) continue;
            }
            if (properties != null) {
                destinationClientInfo.setFavorite(properties.isDestinationFavorite(GlobalPos.func_239648_a_(destination.getDimension(), (BlockPos)c)));
            }
            result.add(destinationClientInfo);
        }
        Collections.sort(result);
        return result;
    }

    public boolean isDestinationValid(TeleportDestination destination) {
        GlobalPos key = GlobalPos.func_239648_a_(destination.getDimension(), (BlockPos)destination.getCoordinate());
        return this.destinations.containsKey(key);
    }

    public void assignId(GlobalPos key, int id) {
        this.destinationById.put(id, key);
        this.destinationIdByCoordinate.put(key, id);
    }

    public int getNewId(GlobalPos key) {
        if (this.destinationIdByCoordinate.containsKey(key)) {
            return this.destinationIdByCoordinate.get(key);
        }
        ++this.lastId;
        this.destinationById.put(this.lastId, key);
        this.destinationIdByCoordinate.put(key, this.lastId);
        return this.lastId;
    }

    public Integer getIdForCoordinate(GlobalPos key) {
        return this.destinationIdByCoordinate.get(key);
    }

    public GlobalPos getCoordinateForId(int id) {
        return this.destinationById.get(id);
    }

    public TeleportDestination addDestination(GlobalPos key) {
        if (!this.destinations.containsKey(key)) {
            TeleportDestination teleportDestination = new TeleportDestination(key.func_218180_b(), (RegistryKey<World>)key.func_239646_a_());
            this.destinations.put(key, teleportDestination);
        }
        return this.destinations.get(key);
    }

    public void removeDestinationsInDimension(RegistryKey<World> dimension) {
        HashSet<GlobalPos> keysToRemove = new HashSet<GlobalPos>();
        for (Map.Entry<GlobalPos, TeleportDestination> entry : this.destinations.entrySet()) {
            if (!entry.getKey().func_239646_a_().equals(dimension)) continue;
            keysToRemove.add(entry.getKey());
        }
        for (GlobalPos key : keysToRemove) {
            this.removeDestination(key.func_218180_b(), (RegistryKey<World>)key.func_239646_a_());
        }
    }

    public void removeDestination(BlockPos coordinate, RegistryKey<World> dimension) {
        if (coordinate == null) {
            return;
        }
        GlobalPos key = GlobalPos.func_239648_a_(dimension, (BlockPos)coordinate);
        this.destinations.remove(key);
        Integer id = this.destinationIdByCoordinate.get(key);
        if (id != null) {
            this.destinationById.remove(id);
            this.destinationIdByCoordinate.remove(key);
        }
    }

    public TeleportDestination getDestination(GlobalPos coordinate) {
        return this.destinations.get(coordinate);
    }

    public TeleportDestination getDestination(BlockPos coordinate, RegistryKey<World> dimension) {
        return this.destinations.get(GlobalPos.func_239648_a_(dimension, (BlockPos)coordinate));
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        this.destinations.clear();
        this.destinationById.clear();
        this.destinationIdByCoordinate.clear();
        this.lastId = tagCompound.func_74762_e("lastId");
        this.readDestinationsFromNBT(tagCompound);
    }

    private void readDestinationsFromNBT(CompoundNBT tagCompound) {
        ListNBT lst = tagCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            BlockPos c = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            String dims = tc.func_74779_i("dim");
            RegistryKey dim = LevelTools.getId((String)dims);
            String name = tc.func_74779_i("name");
            TeleportDestination destination = new TeleportDestination(c, (RegistryKey<World>)dim);
            destination.setName(name);
            GlobalPos gc = GlobalPos.func_239648_a_((RegistryKey)dim, (BlockPos)c);
            this.destinations.put(gc, destination);
            if (!tc.func_74764_b("id")) continue;
            int id = tc.func_74762_e("id");
            this.destinationById.put(id, gc);
            this.destinationIdByCoordinate.put(gc, id);
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT tagCompound) {
        TeleportDestinations.writeDestinationsToNBT(tagCompound, this.destinations.values(), this.destinationIdByCoordinate);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    private static void writeDestinationsToNBT(CompoundNBT tagCompound, Collection<TeleportDestination> destinations, Map<GlobalPos, Integer> coordinateToInteger) {
        ListNBT lst = new ListNBT();
        for (TeleportDestination destination : destinations) {
            Integer id;
            CompoundNBT tc = new CompoundNBT();
            BlockPos c = destination.getCoordinate();
            tc.func_74768_a("x", c.func_177958_n());
            tc.func_74768_a("y", c.func_177956_o());
            tc.func_74768_a("z", c.func_177952_p());
            tc.func_74778_a("dim", destination.getDimension().func_240901_a_().toString());
            tc.func_74778_a("name", destination.getName());
            if (coordinateToInteger != null && (id = coordinateToInteger.get(GlobalPos.func_239648_a_(destination.getDimension(), (BlockPos)c))) != null) {
                tc.func_74768_a("id", id.intValue());
            }
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("destinations", (INBT)lst);
    }
}

