/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.DestinationAnalyzerBlock;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterBoosterBlock;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.client.GuiDialingDevice;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.modules.teleporter.data.TransmitterInfo;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DialingDeviceTileEntity
extends GenericTileEntity {
    public static final Key<Integer> PARAM_STATUS = new Key("status", Type.INTEGER);
    public static final int DIAL_RECEIVER_BLOCKED_MASK = 1;
    public static final int DIAL_TRANSMITTER_BLOCKED_MASK = 2;
    public static final int DIAL_INVALID_DESTINATION_MASK = 4;
    public static final int DIAL_DIALER_POWER_LOW_MASK = 8;
    public static final int DIAL_RECEIVER_POWER_LOW_MASK = 16;
    public static final int DIAL_TRANSMITTER_NOACCESS = 32;
    public static final int DIAL_RECEIVER_NOACCESS = 64;
    public static final int DIAL_INTERRUPTED = 128;
    public static final int DIAL_INVALID_SOURCE_MASK = 256;
    public static final int DIAL_DIMENSION_POWER_LOW_MASK = 512;
    public static final int DIAL_INVALID_TRANSMITTER = 1024;
    public static final int DIAL_OK = 0;
    public static final String COMPONENT_NAME = "dialing_device";
    private boolean showOnlyFavorites = false;
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)TeleportConfiguration.DIALER_MAXENERGY.get()).intValue(), (long)((Integer)TeleportConfiguration.DIALER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dialing Device").containerSupplier(DefaultContainerProvider.empty(TeleporterModule.CONTAINER_DIALING_DEVICE, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    public static final Key<UUID> PARAM_PLAYER_UUID = new Key("playerUuid", Type.UUID);
    @ServerCommand(type=TeleportDestinationClientInfo.class, serializer=TeleportDestinationClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETRECEIVERS = ListCommand.create((String)"rftoolsutility.dialer.getReceivers", (te, player, params) -> te.searchReceivers((UUID)params.get(PARAM_PLAYER_UUID)), (te, player, params, list) -> {
        GuiDialingDevice.fromServer_receivers = list;
    });
    @ServerCommand(type=TransmitterInfo.class, serializer=TransmitterInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETTRANSMITTERS = ListCommand.create((String)"rftoolsutility.dialer.getTransmitters", (te, player, params) -> te.searchTransmitters(), (te, player, params, list) -> {
        GuiDialingDevice.fromServer_transmitters = list;
    });
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<String> PARAM_DIMENSION = new Key("dimension", Type.STRING);
    public static final Key<BlockPos> PARAM_TRANSMITTER = new Key("transmitter", Type.BLOCKPOS);
    public static final Key<String> PARAM_TRANS_DIMENSION = new Key("transDimension", Type.STRING);
    public static final Key<Boolean> PARAM_FAVORITE = new Key("favorite", Type.BOOLEAN);
    @ServerCommand
    public static final Command<?> CMD_FAVORITE = Command.create((String)"dialer.favorite", (te, p, params) -> {
        String player = (String)params.get(PARAM_PLAYER);
        BlockPos receiver = (BlockPos)params.get(PARAM_POS);
        String dimension = (String)params.get(PARAM_DIMENSION);
        boolean favorite = (Boolean)params.get(PARAM_FAVORITE);
        te.changeFavorite(player, receiver, (RegistryKey<World>)LevelTools.getId((String)dimension), favorite);
    });
    @ServerCommand
    public static final Command<?> CMD_SHOWFAVORITE = Command.create((String)"dialer.showFavorite", (te, player, params) -> te.setShowOnlyFavorites((Boolean)params.get(PARAM_FAVORITE)));
    @ServerCommand
    public static final ResultCommand<?> CMD_CHECKSTATUS = ResultCommand.create((String)"checkStatus", (te, player, params) -> {
        BlockPos c = (BlockPos)params.get(PARAM_POS);
        String dim = (String)params.get(PARAM_DIMENSION);
        return TypedMap.builder().put(PARAM_STATUS, (Object)te.checkStatus(c, (RegistryKey<World>)LevelTools.getId((String)dim))).build();
    }, (te, player, params) -> GuiDialingDevice.setReceiverStatus((Integer)params.get(PARAM_STATUS)));
    @ServerCommand
    public static final ResultCommand<?> CMD_DIAL = ResultCommand.create((String)"dial", (te, player, params) -> {
        UUID playerUUID = (UUID)params.get(PARAM_PLAYER_UUID);
        BlockPos transmitter = (BlockPos)params.get(PARAM_TRANSMITTER);
        String transDim = (String)params.get(PARAM_TRANS_DIMENSION);
        BlockPos c = (BlockPos)params.get(PARAM_POS);
        String dim = (String)params.get(PARAM_DIMENSION);
        return TypedMap.builder().put(PARAM_STATUS, (Object)te.dial(playerUUID, transmitter, (RegistryKey<World>)LevelTools.getId((String)transDim), c, (RegistryKey<World>)LevelTools.getId((String)dim), false)).build();
    }, (te, player, params) -> GuiDialingDevice.setDialResult((Integer)params.get(PARAM_STATUS)));
    @ServerCommand
    public static final ResultCommand<?> CMD_DIALONCE = ResultCommand.create((String)"dialOnce", (te, player, params) -> {
        UUID playerUUID = (UUID)params.get(PARAM_PLAYER_UUID);
        BlockPos transmitter = (BlockPos)params.get(PARAM_TRANSMITTER);
        String transDim = (String)params.get(PARAM_TRANS_DIMENSION);
        BlockPos c = (BlockPos)params.get(PARAM_POS);
        String dim = (String)params.get(PARAM_DIMENSION);
        return TypedMap.builder().put(PARAM_STATUS, (Object)te.dial(playerUUID, transmitter, (RegistryKey<World>)LevelTools.getId((String)transDim), c, (RegistryKey<World>)LevelTools.getId((String)dim), true)).build();
    }, (te, player, params) -> GuiDialingDevice.setDialResult((Integer)params.get(PARAM_STATUS)));

    public DialingDeviceTileEntity() {
        super((TileEntityType)TeleporterModule.TYPE_DIALING_DEVICE.get());
    }

    public static String calculateDistance(World world, TransmitterInfo transmitterInfo, TeleportDestination teleportDestination) {
        if (!world.func_234923_W_().equals(teleportDestination.getDimension())) {
            return "dimension warp";
        }
        BlockPos c1 = transmitterInfo.getCoordinate();
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vector3d((double)c1.func_177958_n(), (double)c1.func_177956_o(), (double)c1.func_177952_p()).func_72438_d(new Vector3d((double)c2.func_177958_n(), (double)c2.func_177956_o(), (double)c2.func_177952_p()));
        return Integer.toString((int)dist);
    }

    public static boolean isMatterBoosterAvailable(World world, BlockPos pos) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!((Object)((Object)((MatterBoosterBlock)TeleporterModule.MATTER_BOOSTER.get()))).equals(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDestinationAnalyzerAvailable(World world, BlockPos pos) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!((Object)((Object)((DestinationAnalyzerBlock)TeleporterModule.DESTINATION_ANALYZER.get()))).equals(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    public boolean isShowOnlyFavorites() {
        return this.showOnlyFavorites;
    }

    public void setShowOnlyFavorites(boolean showOnlyFavorites) {
        this.showOnlyFavorites = showOnlyFavorites;
        this.func_70296_d();
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.energyStorage.setEnergy(tagCompound.func_74763_f("Energy"));
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.showOnlyFavorites = info.func_74767_n("showFav");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        this.getOrCreateInfo(tagCompound).func_74757_a("showFav", this.showOnlyFavorites);
        tagCompound.func_74772_a("Energy", this.energyStorage.getEnergy());
        return tagCompound;
    }

    private List<TeleportDestinationClientInfo> searchReceivers(UUID player) {
        TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
        return new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(this.field_145850_b, player));
    }

    public List<TransmitterInfo> searchTransmitters() {
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        int hrange = (Integer)TeleportConfiguration.horizontalDialerRange.get();
        int vrange = (Integer)TeleportConfiguration.verticalDialerRange.get();
        ArrayList<TransmitterInfo> transmitters = new ArrayList<TransmitterInfo>();
        for (int dy = -vrange; dy <= vrange; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.field_145850_b.func_217301_I()) continue;
            for (int dz = -hrange; dz <= hrange; ++dz) {
                int zz = z + dz;
                for (int dx = -hrange; dx <= hrange; ++dx) {
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    BlockPos c = new BlockPos(xx, yy, zz);
                    BlockState state = this.field_145850_b.func_180495_p(c);
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(c);
                    if (!(tileEntity instanceof MatterTransmitterTileEntity)) continue;
                    MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)tileEntity;
                    transmitters.add(new TransmitterInfo(c, matterTransmitterTileEntity.getName(), matterTransmitterTileEntity.getTeleportDestination()));
                }
            }
        }
        return transmitters;
    }

    private void changeFavorite(String playerName, BlockPos receiver, RegistryKey<World> dimension, boolean favorite) {
        List list = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity entity : list) {
            if (!playerName.equals(entity.func_200200_C_().getString())) continue;
            PlayerExtendedProperties.getFavoriteDestinations((PlayerEntity)entity).ifPresent(h -> h.setDestinationFavorite(GlobalPos.func_239648_a_((RegistryKey)dimension, (BlockPos)receiver), favorite));
            return;
        }
    }

    private int dial(UUID player, BlockPos transmitter, RegistryKey<World> transDim, BlockPos coordinate, RegistryKey<World> dimension, boolean once) {
        return TeleportationTools.dial(this.field_145850_b, this, player, transmitter, transDim, coordinate, dimension, once);
    }

    private int checkStatus(BlockPos c, RegistryKey<World> dim) {
        int s;
        int defaultCost = (Integer)TeleportConfiguration.rfPerCheck.get();
        int cost = this.infusableHandler.map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
        if (this.energyStorage.getEnergy() < (long)cost) {
            s = 8;
        } else {
            this.energyStorage.consumeEnergy((long)cost);
            s = 0;
        }
        if (s != 0) {
            return s;
        }
        ServerWorld w = LevelTools.getLevel(dim);
        if (w == null) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            destinations.cleanupInvalid();
            return 4;
        }
        TileEntity tileEntity = w.func_175625_s(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            destinations.cleanupInvalid();
            return 4;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        return matterReceiverTileEntity.checkStatus();
    }
}

