/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.spawner.SpawnerConfiguration;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.spawner.blocks.MatterBeamerTileEntity;
import mcjty.rftoolsutility.modules.spawner.recipes.SpawnerRecipes;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnerTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public float matterReceived0 = -1.0f;
    public float matterReceived1 = -1.0f;
    public float matterReceived2 = -1.0f;
    public static final int SLOT_SYRINGE = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).box(SlotDefinition.specific((Item[])new Item[]{(Item)SpawnerModule.SYRINGE.get()}).in().out(), 0, 22, 8, 1, 18, 1, 18).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.match(SpawnerModule.SYRINGE)).onUpdate((slot, stack) -> {
        this.checkSyringe = true;
        this.prevMobId = this.mobId;
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)SpawnerConfiguration.SPAWNER_MAXENERGY, (long)SpawnerConfiguration.SPAWNER_RECEIVEPERTICK);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Spawner").containerSupplier(DefaultContainerProvider.container(SpawnerModule.CONTAINER_SPAWNER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    private final LazyOptional<IMachineInformation> infoHandler = LazyOptional.of(this::createMachineInfo);
    @Cap(type=CapType.MODULE)
    private final LazyOptional<IModuleSupport> moduleSupportHandler = LazyOptional.of(() -> new DefaultModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() == SpawnerModule.SYRINGE.get();
        }
    });
    private float[] matter = new float[]{0.0f, 0.0f, 0.0f};
    private boolean checkSyringe = true;
    private String prevMobId = null;
    private String mobId = "";
    private AxisAlignedBB entityCheckBox = null;
    public static final Key<Double> PARAM_MATTER0 = new Key("matter0", Type.DOUBLE);
    public static final Key<Double> PARAM_MATTER1 = new Key("matter1", Type.DOUBLE);
    public static final Key<Double> PARAM_MATTER2 = new Key("matter2", Type.DOUBLE);
    @ServerCommand
    public static final ResultCommand<?> CMD_GET_SPAWNERINFO = ResultCommand.create((String)"getSpawnerInfo", (te, player, params) -> TypedMap.builder().put(PARAM_MATTER0, (Object)te.matter[0]).put(PARAM_MATTER1, (Object)te.matter[1]).put(PARAM_MATTER2, (Object)te.matter[2]).build(), (te, player, params) -> {
        te.matterReceived0 = ((Double)params.get(PARAM_MATTER0)).floatValue();
        te.matterReceived1 = ((Double)params.get(PARAM_MATTER1)).floatValue();
        te.matterReceived2 = ((Double)params.get(PARAM_MATTER2)).floatValue();
    });

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(SpawnerTileEntity::new).topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsutility:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public SpawnerTileEntity() {
        super((TileEntityType)SpawnerModule.TYPE_SPAWNER.get());
    }

    private void testSyringe() {
        if (!this.checkSyringe) {
            return;
        }
        this.checkSyringe = false;
        this.mobId = null;
        ItemStack itemStack = this.items.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            this.clearMatter();
            return;
        }
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            this.clearMatter();
            return;
        }
        this.mobId = tagCompound.func_74779_i("mobId");
        if (this.mobId.isEmpty()) {
            this.clearMatter();
            return;
        }
        int level = tagCompound.func_74762_e("level");
        if (level < (Integer)SpawnerConfiguration.maxMobInjections.get()) {
            this.clearMatter();
            return;
        }
        if (this.prevMobId != null && !this.prevMobId.equals(this.mobId)) {
            this.clearMatter();
        }
    }

    public GenericItemHandler getItems() {
        return this.items;
    }

    private void clearMatter() {
        if (this.matter[0] != 0.0f || this.matter[1] != 0.0f || this.matter[2] != 0.0f) {
            this.matter[2] = 0.0f;
            this.matter[1] = 0.0f;
            this.matter[0] = 0.0f;
            this.func_70296_d();
        }
    }

    public boolean addMatter(ItemStack stack, int m, float beamerInfusionFactor) {
        this.testSyringe();
        if (this.mobId == null || this.mobId.isEmpty()) {
            return false;
        }
        int materialType = 0;
        Float factor = null;
        SpawnerRecipes.MobData mobData = this.getMobData();
        if (mobData == null) {
            return false;
        }
        for (int i = 0; i < 3 && (factor = mobData.getItem(i).match(stack)) == null; ++i) {
            ++materialType;
        }
        if (factor == null) {
            return false;
        }
        float mm = this.matter[materialType];
        if ((mm += (float)m * factor.floatValue() * 3.0f / (3.0f - beamerInfusionFactor)) > (float)SpawnerConfiguration.maxMatterStorage) {
            mm = SpawnerConfiguration.maxMatterStorage;
        }
        this.matter[materialType] = mm;
        this.func_70296_d();
        return true;
    }

    @Nullable
    private SpawnerRecipes.MobData getMobData() {
        SpawnerRecipes.MobData mobData = SpawnerRecipes.getMobData(this.field_145850_b, this.mobId);
        if (mobData == null) {
            Logging.logError((String)("The mob spawn amounts list for mob " + this.mobId + " is missing!"));
        }
        return mobData;
    }

    public float[] getMatter() {
        return this.matter;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        this.testSyringe();
        if (this.mobId == null || this.mobId.isEmpty()) {
            return;
        }
        SpawnerRecipes.MobData mobData = this.getMobData();
        if (mobData == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (!(this.matter[i] < mobData.getItem(i).getAmount())) continue;
            return;
        }
        Integer rf = mobData.getSpawnRf();
        rf = (int)((float)rf.intValue() * (2.0f - this.infusable.getInfusedFactor()) / 2.0f);
        if (this.energyStorage.getEnergyStored() < rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rf.intValue());
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.matter[n] = this.matter[n] - mobData.getItem(i).getAmount();
        }
        this.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        Direction k = OrientationTools.getOrientation((BlockState)state);
        int sx = this.func_174877_v().func_177958_n();
        int sy = this.func_174877_v().func_177956_o();
        int sz = this.func_174877_v().func_177952_p();
        Vector3i dir = k.func_176730_m();
        sx += dir.func_177958_n();
        sy += dir.func_177956_o();
        sz += dir.func_177952_p();
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(this.mobId));
        if (type == null) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobId));
            return;
        }
        Entity entityLiving = type.func_200721_a(this.field_145850_b);
        if (entityLiving == null) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobId));
            return;
        }
        if (k == Direction.DOWN) {
            sy = (int)((float)sy - (entityLiving.func_70047_e() - 1.0f));
        }
        entityLiving.func_70012_b((double)sx + 0.5, (double)sy, (double)sz + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_217376_c(entityLiving);
    }

    public void useWrench(PlayerEntity player) {
        BlockPos coord = RFToolsBase.instance.clientInfo.getSelectedTE();
        if (coord == null) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(coord);
        double d = new Vector3d((double)coord.func_177958_n(), (double)coord.func_177956_o(), (double)coord.func_177952_p()).func_72438_d(new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()));
        if (d > (double)SpawnerConfiguration.maxBeamDistance) {
            Logging.message((PlayerEntity)player, (String)"Destination distance is too far!");
        } else if (tileEntity instanceof MatterBeamerTileEntity) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)tileEntity;
            matterBeamerTileEntity.setDestination(this.func_174877_v());
            Logging.message((PlayerEntity)player, (String)"Destination set!");
        }
        RFToolsBase.instance.clientInfo.setSelectedTE(null);
        RFToolsBase.instance.clientInfo.setDestinationTE(null);
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.matter[0] = info.func_74760_g("matter0");
        this.matter[1] = info.func_74760_g("matter1");
        this.matter[2] = info.func_74760_g("matter2");
        this.mobId = info.func_74764_b("mobId") ? info.func_74779_i("mobId") : null;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74776_a("matter0", this.matter[0]);
        info.func_74776_a("matter1", this.matter[1]);
        info.func_74776_a("matter2", this.matter[2]);
        if (this.mobId != null && !this.mobId.isEmpty()) {
            info.func_74778_a("mobId", this.mobId);
        }
    }

    public boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        if (world.field_72995_K) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_189107_dL, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            this.useWrench(player);
        }
        return true;
    }

    @Nonnull
    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"matter1", "matter2", "matter3", "mob"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"The amount of matter in the first slot", "The amount of matter in the second slot", "The amount of matter in the third slot", "The name of the mob being spawned"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                switch (index) {
                    case 0: {
                        return Float.toString(SpawnerTileEntity.this.matter[0]);
                    }
                    case 1: {
                        return Float.toString(SpawnerTileEntity.this.matter[1]);
                    }
                    case 2: {
                        return Float.toString(SpawnerTileEntity.this.matter[2]);
                    }
                    case 3: {
                        return SpawnerTileEntity.this.mobId;
                    }
                }
                return null;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY) {
            return this.infoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

