/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.IScreenModuleUpdater;
import mcjty.rftoolsbase.api.screens.ITooltipInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsutility.modules.screen.NbtSanitizerModuleGuiBuilder;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenContainer;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataBoolean;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataInteger;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataString;
import mcjty.rftoolsutility.modules.screen.modules.ComputerScreenModule;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;
import mcjty.rftoolsutility.modules.screen.modulesclient.TextClientScreenModule;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class ScreenTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public List<String> infoReceived = Collections.emptyList();
    @GuiValue
    private boolean bright = false;
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, ScreenContainer.CONTAINER_FACTORY).onUpdate((slot, stack) -> this.resetModules()).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Screen").containerSupplier(windowId -> ScreenContainer.create(windowId, this.func_174877_v(), this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.MODULE)
    private final LazyOptional<IModuleSupport> moduleSupportHandler = LazyOptional.of(() -> new DefaultModuleSupport(0, 10){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof IModuleProvider;
        }
    });
    public static final Map<GlobalPos, Map<Integer, IModuleData>> screenData = new HashMap<GlobalPos, Map<Integer, IModuleData>>();
    private List<IClientScreenModule<?>> clientScreenModules = null;
    private final Map<String, List<ComputerScreenModule>> computerModules = new HashMap<String, List<ComputerScreenModule>>();
    private RegistryKey<World> dummyType = null;
    private boolean needsServerData = false;
    private boolean showHelp = true;
    private boolean powerOn = false;
    private boolean connected = false;
    private int size = 0;
    private boolean transparent = false;
    private int color = 0;
    private int trueTypeMode = 0;
    private int hoveringModule = -1;
    private int hoveringX = -1;
    private int hoveringY = -1;
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_LARGE = 1;
    public static final int SIZE_HUGE = 2;
    private List<IScreenModule<?>> screenModules = null;
    private List<ActivatedModule> clickedModules = new ArrayList<ActivatedModule>();
    private int totalRfPerTick = 0;
    private boolean controllerNeededInCreative = false;
    public long lastTime = 0L;
    private static List<IClientScreenModule<?>> helpingScreenModules = null;
    private IScreenDataHelper screenDataHelper = new IScreenDataHelper(){

        public IModuleDataInteger createInteger(int i) {
            return new ModuleDataInteger(i);
        }

        public IModuleDataBoolean createBoolean(boolean b) {
            return new ModuleDataBoolean(b);
        }

        public IModuleDataString createString(String b) {
            return new ModuleDataString(b);
        }

        public IModuleDataContents createContents(long contents, long maxContents, long lastPerTick) {
            return new ScreenModuleHelper.ModuleDataContents(contents, maxContents, lastPerTick);
        }
    };
    public static final Key<Integer> PARAM_X = new Key("x", Type.INTEGER);
    public static final Key<Integer> PARAM_Y = new Key("y", Type.INTEGER);
    public static final Key<Integer> PARAM_MODULE = new Key("module", Type.INTEGER);
    public static final Key<Integer> PARAM_TRUETYPE = new Key("truetype", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_CLICK = Command.create((String)"screen.click", (te, player, params) -> te.hitScreenServer(player, (Integer)params.get(PARAM_X), (Integer)params.get(PARAM_Y), (Integer)params.get(PARAM_MODULE)));
    @ServerCommand
    public static final Command<?> CMD_HOVER = Command.create((String)"screen.hover", (te, player, params) -> {
        te.hoveringX = (Integer)params.get(PARAM_X);
        te.hoveringY = (Integer)params.get(PARAM_Y);
        te.hoveringModule = (Integer)params.get(PARAM_MODULE);
    });
    @ServerCommand
    public static final Command<?> CMD_SETTRUETYPE = Command.create((String)"screen.setTruetype", (te, player, params) -> te.setTrueTypeMode((Integer)params.get(PARAM_TRUETYPE)));
    public static final Key<List<String>> PARAM_INFO = new Key("info", Type.STRING_LIST);
    @ServerCommand
    public static final ResultCommand<?> CMD_SCREEN_INFO = ResultCommand.create((String)"getScreenInfo", (te, player, params) -> {
        IScreenModule<?> module = te.getHoveringModule((Integer)params.get(PARAM_MODULE));
        List info = Collections.emptyList();
        if (module instanceof ITooltipInfo) {
            info = ((ITooltipInfo)module).getInfo(te.field_145850_b, ((Integer)params.get(PARAM_X)).intValue(), ((Integer)params.get(PARAM_Y)).intValue());
        }
        return TypedMap.builder().put(PARAM_INFO, info).build();
    }, (te, player, params) -> {
        te.infoReceived = (List)params.get(PARAM_INFO);
    });

    public ScreenTileEntity() {
        super((TileEntityType)ScreenModule.TYPE_SCREEN.get());
    }

    public ScreenTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public ScreenTileEntity(RegistryKey<World> world) {
        this();
        this.dummyType = world;
    }

    public ScreenTileEntity(TileEntityType<?> type, RegistryKey<World> world) {
        this(type);
        this.dummyType = world;
    }

    public boolean isDummy() {
        return this.dummyType != null;
    }

    public RegistryKey<World> getDimension() {
        if (this.dummyType != null) {
            return this.dummyType;
        }
        return super.getDimension();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        return new AxisAlignedBB((double)(xCoord - this.size - 1), (double)(yCoord - this.size - 1), (double)(zCoord - this.size - 1), (double)(xCoord + this.size + 1), (double)(yCoord + this.size + 1), (double)(zCoord + this.size + 1));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    private void checkStateClient() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        ArrayList<ActivatedModule> newClickedModules = new ArrayList<ActivatedModule>();
        for (ActivatedModule cm : this.clickedModules) {
            cm.ticks--;
            if (cm.ticks > 0) {
                newClickedModules.add(cm);
                continue;
            }
            List<IClientScreenModule<?>> modules = this.getClientScreenModules();
            if (cm.module >= modules.size()) continue;
            modules.get(cm.module).mouseClick(this.field_145850_b, cm.x, cm.y, false);
        }
        this.clickedModules = newClickedModules;
    }

    private void checkStateServer() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        ArrayList<ActivatedModule> newClickedModules = new ArrayList<ActivatedModule>();
        for (ActivatedModule cm : this.clickedModules) {
            CompoundNBT newCompound;
            cm.ticks--;
            if (cm.ticks > 0) {
                newClickedModules.add(cm);
                continue;
            }
            List<IScreenModule<?>> modules = this.getScreenModules();
            if (cm.module >= modules.size()) continue;
            ItemStack itemStack = this.items.getStackInSlot(cm.module);
            IScreenModule<?> module = modules.get(cm.module);
            module.mouseClick(this.field_145850_b, cm.x, cm.y, false, null);
            if (!(module instanceof IScreenModuleUpdater) || (newCompound = ((IScreenModuleUpdater)module).update(itemStack.func_77978_p(), this.field_145850_b, null)) == null) continue;
            itemStack.func_77982_d(newCompound);
            this.markDirtyClient();
        }
        this.clickedModules = newClickedModules;
    }

    private void resetModules() {
        this.clientScreenModules = null;
        this.screenModules = null;
        this.clickedModules.clear();
        this.showHelp = true;
        this.computerModules.clear();
    }

    private boolean isActivated(int index) {
        for (ActivatedModule module : this.clickedModules) {
            if (module.module != index) continue;
            return true;
        }
        return false;
    }

    public void focusModuleClient(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing) {
        int module;
        int y;
        int x;
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side, horizontalFacing, this.size);
        if (result == null) {
            x = -1;
            y = -1;
            module = -1;
        } else {
            x = result.getX();
            y = result.getY() - result.getCurrenty();
            module = result.getModuleIndex();
        }
        if (x != this.hoveringX || y != this.hoveringY || module != this.hoveringModule) {
            PacketServerCommandTyped packet = new PacketServerCommandTyped(this.func_174877_v(), this.getDimension(), CMD_HOVER.getName(), TypedMap.builder().put(PARAM_X, (Object)x).put(PARAM_Y, (Object)y).put(PARAM_MODULE, (Object)module).build());
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)packet);
            this.hoveringX = x;
            this.hoveringY = y;
            this.hoveringModule = module;
        }
    }

    public void hitScreenClient(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing) {
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side, horizontalFacing, this.size);
        if (result == null) {
            return;
        }
        this.hitScreenClient(result);
    }

    public void hitScreenClient(ModuleRaytraceResult result) {
        List<IClientScreenModule<?>> modules = this.getClientScreenModules();
        int module = result.getModuleIndex();
        if (this.isActivated(module)) {
            return;
        }
        modules.get(module).mouseClick(this.field_145850_b, result.getX(), result.getY() - result.getCurrenty(), true);
        this.clickedModules.add(new ActivatedModule(module, 3, result.getX(), result.getY()));
        PacketServerCommandTyped packet = new PacketServerCommandTyped(this.func_174877_v(), this.getDimension(), CMD_CLICK.getName(), TypedMap.builder().put(PARAM_X, (Object)result.getX()).put(PARAM_Y, (Object)(result.getY() - result.getCurrenty())).put(PARAM_MODULE, (Object)module).build());
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)packet);
    }

    public ModuleRaytraceResult getHitModule(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing, int size) {
        float factor = (float)size + 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        switch (side) {
            case NORTH: {
                dx = (float)((1.0 - hitX) / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case SOUTH: {
                dx = (float)(hitX / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case WEST: {
                dx = (float)(hitZ / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case EAST: {
                dx = (float)((1.0 - hitZ) / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case UP: {
                switch (horizontalFacing) {
                    case NORTH: {
                        dx = (float)((1.0 - hitX) / (double)factor);
                        dy = (float)((1.0 - hitZ) / (double)factor);
                        break;
                    }
                    case SOUTH: {
                        dx = (float)(hitX / (double)factor);
                        dy = (float)(hitZ / (double)factor);
                        break;
                    }
                    case WEST: {
                        dx = (float)(hitZ / (double)factor);
                        dy = (float)((1.0 - hitX) / (double)factor);
                        break;
                    }
                    case EAST: {
                        dx = (float)((1.0 - hitZ) / (double)factor);
                        dy = (float)(hitX / (double)factor);
                    }
                }
                break;
            }
            case DOWN: {
                switch (horizontalFacing) {
                    case NORTH: {
                        dx = (float)((1.0 - hitX) / (double)factor);
                        dy = (float)(hitZ / (double)factor);
                        break;
                    }
                    case SOUTH: {
                        dx = (float)(hitX / (double)factor);
                        dy = (float)((1.0 - hitZ) / (double)factor);
                        break;
                    }
                    case WEST: {
                        dx = (float)(hitZ / (double)factor);
                        dy = (float)(hitX / (double)factor);
                        break;
                    }
                    case EAST: {
                        dx = (float)((1.0 - hitZ) / (double)factor);
                        dy = (float)((1.0 - hitX) / (double)factor);
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        int x = (int)(dx * 128.0f);
        int y = (int)(dy * 128.0f);
        int currenty = 7;
        int moduleIndex = 0;
        List<IClientScreenModule<?>> clientScreenModules = this.getClientScreenModules();
        for (IClientScreenModule<?> module : clientScreenModules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (currenty <= y && y < currenty + height) break;
                currenty += height;
            }
            ++moduleIndex;
        }
        if (moduleIndex >= clientScreenModules.size()) {
            return null;
        }
        ModuleRaytraceResult result = new ModuleRaytraceResult(moduleIndex, x, y, currenty);
        return result;
    }

    private void hitScreenServer(PlayerEntity player, int x, int y, int module) {
        List<IScreenModule<?>> screenModules = this.getScreenModules();
        IScreenModule<?> screenModule = screenModules.get(module);
        if (screenModule != null) {
            CompoundNBT newCompound;
            ItemStack itemStack = this.items.getStackInSlot(module);
            screenModule.mouseClick(this.field_145850_b, x, y, true, player);
            if (screenModule instanceof IScreenModuleUpdater && (newCompound = ((IScreenModuleUpdater)screenModule).update(itemStack.func_77978_p(), this.field_145850_b, player)) != null) {
                itemStack.func_77982_d(newCompound);
                this.markDirtyClient();
            }
            this.clickedModules.add(new ActivatedModule(module, 5, x, y));
        }
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.powerOn = tagCompound.func_74767_n("powerOn");
        this.connected = tagCompound.func_74767_n("connected");
        this.totalRfPerTick = tagCompound.func_74762_e("rfPerTick");
        this.controllerNeededInCreative = tagCompound.func_74767_n("controllerNeededInCreative");
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(CompoundNBT tagCompound) {
        this.resetModules();
        this.size = tagCompound.func_74764_b("large") ? (tagCompound.func_74767_n("large") ? 1 : 0) : tagCompound.func_74762_e("size");
        this.transparent = tagCompound.func_74767_n("transparent");
        this.color = tagCompound.func_74762_e("color");
        this.bright = tagCompound.func_74767_n("bright");
        this.trueTypeMode = tagCompound.func_74762_e("truetype");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("powerOn", this.powerOn);
        tagCompound.func_74757_a("connected", this.connected);
        tagCompound.func_74768_a("rfPerTick", this.totalRfPerTick);
        tagCompound.func_74757_a("controllerNeededInCreative", this.controllerNeededInCreative);
        this.writeRestorableToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("size", this.size);
        tagCompound.func_74757_a("transparent", this.transparent);
        tagCompound.func_74768_a("color", this.color);
        tagCompound.func_74757_a("bright", this.bright);
        tagCompound.func_74768_a("truetype", this.trueTypeMode);
    }

    public void writeClientDataToNBT(CompoundNBT tagCompound) {
        this.writeRestorableToNBT(tagCompound);
        this.writeItemHandlerCap(tagCompound);
        tagCompound.func_74757_a("powerOn", this.powerOn);
        tagCompound.func_74757_a("connected", this.connected);
    }

    public void readClientDataFromNBT(CompoundNBT tagCompound) {
        this.powerOn = tagCompound.func_74767_n("powerOn");
        this.connected = tagCompound.func_74767_n("connected");
        this.readRestorableFromNBT(tagCompound);
        this.readItemHandlerCap(tagCompound);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.func_70296_d();
    }

    public void setSize(int size) {
        this.size = size;
        this.func_70296_d();
    }

    public boolean isBright() {
        return this.bright;
    }

    public void setBright(boolean bright) {
        this.bright = bright;
        this.func_70296_d();
    }

    public int getTrueTypeMode() {
        return this.trueTypeMode;
    }

    public void setTrueTypeMode(int trueTypeMode) {
        this.trueTypeMode = trueTypeMode;
        this.func_70296_d();
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.func_70296_d();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setPower(boolean power) {
        if (this.powerOn == power) {
            return;
        }
        this.powerOn = power;
        this.markDirtyClient();
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isRenderable() {
        if (this.powerOn) {
            return true;
        }
        if (this.isShowHelp()) {
            return true;
        }
        return this.isCreative();
    }

    public boolean isCreative() {
        return false;
    }

    public void setConnected(boolean c) {
        if (this.connected == c) {
            return;
        }
        this.connected = c;
        this.func_70296_d();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void updateModuleData(int slot, CompoundNBT tagCompound) {
        ItemStack stack = this.items.getStackInSlot(slot);
        ScreenBlock.getModuleProvider(stack).ifPresent(moduleProvider -> {
            NbtSanitizerModuleGuiBuilder sanitizer = new NbtSanitizerModuleGuiBuilder(this.field_145850_b, stack.func_77978_p());
            moduleProvider.createGui((IModuleGuiBuilder)sanitizer);
            stack.func_77982_d(sanitizer.sanitizeNbt(tagCompound));
            this.screenModules = null;
            this.clientScreenModules = null;
            this.computerModules.clear();
            this.markDirtyClient();
        });
    }

    public static List<IClientScreenModule<?>> getHelpingScreenModules() {
        if (helpingScreenModules == null) {
            helpingScreenModules = new ArrayList();
            ScreenTileEntity.addLine("Read me", 0x7799FF, true);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Sneak-right click for", 0xFFFFFF, false);
            ScreenTileEntity.addLine("GUI and insertion of", 0xFFFFFF, false);
            ScreenTileEntity.addLine("modules", 0xFFFFFF, false);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Use Screen Controller", 0xFFFFFF, false);
            ScreenTileEntity.addLine("to power screens", 0xFFFFFF, false);
            ScreenTileEntity.addLine("remotely", 0xFFFFFF, false);
        }
        return helpingScreenModules;
    }

    private static void addLine(String s, int color, boolean large) {
        TextClientScreenModule t1 = new TextClientScreenModule();
        t1.setLine(s);
        t1.setColor(color);
        t1.setLarge(large);
        helpingScreenModules.add(t1);
    }

    public List<IClientScreenModule<?>> getClientScreenModules() {
        if (this.clientScreenModules == null) {
            this.needsServerData = false;
            this.showHelp = true;
            this.clientScreenModules = new ArrayList();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (!itemStack.func_190926_b() && ScreenBlock.hasModuleProvider(itemStack)) {
                    ScreenBlock.getModuleProvider(itemStack).ifPresent(moduleProvider -> {
                        IClientScreenModule clientScreenModule;
                        try {
                            clientScreenModule = (IClientScreenModule)moduleProvider.getClientScreenModule().newInstance();
                        }
                        catch (InstantiationException e) {
                            Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                            return;
                        }
                        catch (IllegalAccessException e) {
                            Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                            return;
                        }
                        clientScreenModule.setupFromNBT(itemStack.func_77978_p(), this.field_145850_b.func_234923_W_(), this.func_174877_v());
                        this.clientScreenModules.add(clientScreenModule);
                        if (clientScreenModule.needsServerData()) {
                            this.needsServerData = true;
                        }
                        this.showHelp = false;
                    });
                    continue;
                }
                this.clientScreenModules.add(null);
            }
        }
        return this.clientScreenModules;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public boolean isNeedsServerData() {
        return this.needsServerData;
    }

    public int getTotalRfPerTick() {
        if (this.isCreative()) {
            return 0;
        }
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.totalRfPerTick;
    }

    public boolean isControllerNeeded() {
        if (!this.isCreative()) {
            return true;
        }
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.controllerNeededInCreative;
    }

    public List<IScreenModule<?>> getScreenModules() {
        if (this.screenModules == null) {
            this.totalRfPerTick = 0;
            this.controllerNeededInCreative = false;
            this.screenModules = new ArrayList();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (!itemStack.func_190926_b() && ScreenBlock.hasModuleProvider(itemStack)) {
                    ScreenBlock.getModuleProvider(itemStack).ifPresent(moduleProvider -> {
                        IScreenModule screenModule;
                        try {
                            screenModule = (IScreenModule)moduleProvider.getServerScreenModule().newInstance();
                        }
                        catch (InstantiationException e) {
                            Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                            return;
                        }
                        catch (IllegalAccessException e) {
                            Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                            return;
                        }
                        screenModule.setupFromNBT(itemStack.func_77978_p(), this.field_145850_b.func_234923_W_(), this.func_174877_v());
                        this.screenModules.add(screenModule);
                        this.totalRfPerTick += screenModule.getRfPerTick();
                        if (screenModule.needsController()) {
                            this.controllerNeededInCreative = true;
                        }
                        if (screenModule instanceof ComputerScreenModule) {
                            ComputerScreenModule computerScreenModule = (ComputerScreenModule)screenModule;
                            String tag = computerScreenModule.getTag();
                            if (!this.computerModules.containsKey(tag)) {
                                this.computerModules.put(tag, new ArrayList());
                            }
                            this.computerModules.get(tag).add(computerScreenModule);
                        }
                    });
                    continue;
                }
                this.screenModules.add(null);
            }
        }
        return this.screenModules;
    }

    public List<ComputerScreenModule> getComputerModules(String tag) {
        return this.computerModules.get(tag);
    }

    public Set<String> getTags() {
        return this.computerModules.keySet();
    }

    public Map<Integer, IModuleData> getScreenData(long millis) {
        HashMap<Integer, IModuleData> map = new HashMap<Integer, IModuleData>();
        List<IScreenModule<?>> screenModules = this.getScreenModules();
        int moduleIndex = 0;
        for (IScreenModule<?> module : screenModules) {
            IModuleData data;
            if (module != null && (data = module.getData(this.screenDataHelper, this.field_145850_b, millis)) != null) {
                map.put(moduleIndex, data);
            }
            ++moduleIndex;
        }
        return map;
    }

    public IScreenModule<?> getHoveringModule() {
        return this.getHoveringModule(this.hoveringModule);
    }

    public IScreenModule<?> getHoveringModule(int hoveringModule) {
        if (hoveringModule == -1) {
            return null;
        }
        this.getScreenModules();
        if (hoveringModule >= 0 && hoveringModule < this.screenModules.size()) {
            return this.screenModules.get(hoveringModule);
        }
        return null;
    }

    public int getHoveringX() {
        return this.hoveringX;
    }

    public int getHoveringY() {
        return this.hoveringY;
    }

    private static class ActivatedModule {
        private int module;
        private int ticks;
        private int x;
        private int y;

        public ActivatedModule(int module, int ticks, int x, int y) {
            this.module = module;
            this.ticks = ticks;
            this.x = x;
            this.y = y;
        }
    }

    public static class ModuleRaytraceResult {
        private final int x;
        private final int y;
        private final int currenty;
        private final int moduleIndex;

        public ModuleRaytraceResult(int moduleIndex, int x, int y, int currenty) {
            this.moduleIndex = moduleIndex;
            this.x = x;
            this.y = y;
            this.currenty = currenty;
        }

        public int getModuleIndex() {
            return this.moduleIndex;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getCurrenty() {
            return this.currenty;
        }
    }
}

