/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenHitTileEntity;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ScreenHitBlock
extends BaseBlock {
    public ScreenHitBlock() {
        super(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(-1.0f, 3600000.0f).func_200947_a(SoundType.field_185852_e)).tileEntitySupplier(ScreenHitTileEntity::new));
    }

    @Nonnull
    public ItemStack func_185473_a(@Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockPos screenPos = this.getScreenBlockPos(worldIn, pos);
        if (screenPos == null) {
            return ItemStack.field_190927_a;
        }
        BlockState screenState = worldIn.func_180495_p(screenPos);
        return screenState.func_177230_c().func_185473_a(worldIn, screenPos, screenState);
    }

    public void func_196270_a(@Nonnull BlockState s, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player) {
        if (world.field_72995_K) {
            int dz;
            int dy;
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_175625_s(pos);
            int dx = screenHitTileEntity.getDx();
            BlockState state = world.func_180495_p(pos.func_177982_a(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz()));
            Block block = state.func_177230_c();
            if (block != ScreenModule.SCREEN.get() && block != ScreenModule.CREATIVE_SCREEN.get()) {
                return;
            }
            RayTraceResult mouseOver = McJtyLib.proxy.getClientMouseOver();
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos.func_177982_a(dx, dy, dz));
            if (mouseOver instanceof BlockRayTraceResult) {
                screenTileEntity.hitScreenClient(mouseOver.func_216347_e().field_72450_a - (double)pos.func_177958_n() - (double)dx, mouseOver.func_216347_e().field_72448_b - (double)pos.func_177956_o() - (double)dy, mouseOver.func_216347_e().field_72449_c - (double)pos.func_177952_p() - (double)dz, ((BlockRayTraceResult)mouseOver).func_216354_b(), (Direction)state.func_177229_b((Property)ScreenBlock.HORIZ_FACING));
            }
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult result) {
        return this.activate(world, pos, state, player, hand, result);
    }

    public ActionResultType activate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if ((pos = this.getScreenBlockPos((IBlockReader)world, pos)) == null) {
            return ActionResultType.PASS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        return ((ScreenBlock)block).activate(world, pos, state, player, hand, result);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        return state;
    }

    public BlockPos getScreenBlockPos(IBlockReader world, BlockPos pos) {
        int dz;
        int dy;
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_175625_s(pos);
        int dx = screenHitTileEntity.getDx();
        Block block = world.func_180495_p(pos = pos.func_177982_a(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz())).func_177230_c();
        if (block != ScreenModule.SCREEN.get() && block != ScreenModule.CREATIVE_SCREEN.get()) {
            return null;
        }
        return pos;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        if (facing == Direction.NORTH) {
            return ScreenBlock.NORTH_AABB;
        }
        if (facing == Direction.SOUTH) {
            return ScreenBlock.SOUTH_AABB;
        }
        if (facing == Direction.WEST) {
            return ScreenBlock.WEST_AABB;
        }
        if (facing == Direction.EAST) {
            return ScreenBlock.EAST_AABB;
        }
        if (facing == Direction.UP) {
            return ScreenBlock.UP_AABB;
        }
        if (facing == Direction.DOWN) {
            return ScreenBlock.DOWN_AABB;
        }
        return ScreenBlock.BLOCK_AABB;
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public void func_180652_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }
}

