/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class ScreenControllerTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(0).playerSlots(10, 70));
    public static final String COMPONENT_NAME = "screen_controller";
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)ScreenConfiguration.CONTROLLER_MAXENERGY.get()).intValue(), (long)((Integer)ScreenConfiguration.CONTROLLER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Screen Controller").containerSupplier(DefaultContainerProvider.container(ScreenModule.CONTAINER_SCREEN_CONTROLLER, CONTAINER_FACTORY, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private List<BlockPos> connectedScreens = new ArrayList<BlockPos>();
    private int tickCounter = 20;
    @ServerCommand
    public static final Command<?> CMD_SCAN = Command.create((String)"scan", (te, player, params) -> te.scan());
    @ServerCommand
    public static final Command<?> CMD_DETACH = Command.create((String)"detach", (te, player, params) -> te.detach());

    public ScreenControllerTileEntity() {
        super((TileEntityType)ScreenModule.TYPE_SCREEN_CONTROLLER.get());
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        int[] xes = tagCompound.func_74759_k("screensx");
        int[] yes = tagCompound.func_74759_k("screensy");
        int[] zes = tagCompound.func_74759_k("screensz");
        this.connectedScreens.clear();
        for (int i = 0; i < xes.length; ++i) {
            this.connectedScreens.add(new BlockPos(xes[i], yes[i], zes[i]));
        }
        this.energyStorage.setEnergy(tagCompound.func_74763_f("Energy"));
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        int[] xes = new int[this.connectedScreens.size()];
        int[] yes = new int[this.connectedScreens.size()];
        int[] zes = new int[this.connectedScreens.size()];
        for (int i = 0; i < this.connectedScreens.size(); ++i) {
            BlockPos c = this.connectedScreens.get(i);
            xes[i] = c.func_177958_n();
            yes[i] = c.func_177956_o();
            zes[i] = c.func_177952_p();
        }
        tagCompound.func_74783_a("screensx", xes);
        tagCompound.func_74783_a("screensy", yes);
        tagCompound.func_74783_a("screensz", zes);
        tagCompound.func_74772_a("Energy", this.energyStorage.getEnergy());
        return tagCompound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        long rf;
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 20;
        long rememberRf = rf = this.energyStorage.getEnergy();
        boolean fixesAreNeeded = false;
        for (BlockPos c : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_175625_s(c);
            if (te instanceof ScreenTileEntity) {
                ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
                int rfModule = screenTileEntity.getTotalRfPerTick() * 20;
                if ((long)rfModule > rf) {
                    screenTileEntity.setPower(false);
                    continue;
                }
                rf -= (long)rfModule;
                screenTileEntity.setPower(true);
                continue;
            }
            fixesAreNeeded = true;
        }
        if (rf < rememberRf) {
            this.energyStorage.consumeEnergy(rememberRf - rf);
        }
        if (fixesAreNeeded) {
            ArrayList<BlockPos> newScreens = new ArrayList<BlockPos>();
            for (BlockPos c : this.connectedScreens) {
                TileEntity te = this.field_145850_b.func_175625_s(c);
                if (!(te instanceof ScreenTileEntity)) continue;
                newScreens.add(c);
            }
            this.connectedScreens = newScreens;
            this.func_70296_d();
        }
    }

    private void scan() {
        this.detach();
        float factor = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f)).floatValue();
        int radius = 32 + (int)(factor * 32.0f);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (int y = yCoord - radius; y <= yCoord + radius; ++y) {
            if (y < 0 || y >= 256) continue;
            for (int x = xCoord - radius; x <= xCoord + radius; ++x) {
                for (int z = zCoord - radius; z <= zCoord + radius; ++z) {
                    ScreenTileEntity ste;
                    TileEntity te;
                    BlockPos spos = new BlockPos(x, y, z);
                    if (!(this.field_145850_b.func_180495_p(spos).func_177230_c() instanceof ScreenBlock) || !((te = this.field_145850_b.func_175625_s(spos)) instanceof ScreenTileEntity) || (ste = (ScreenTileEntity)te).isConnected() || !ste.isControllerNeeded()) continue;
                    this.connectedScreens.add(spos);
                    ste.setConnected(true);
                }
            }
        }
        this.func_70296_d();
    }

    public void detach() {
        for (BlockPos c : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_175625_s(c);
            if (!(te instanceof ScreenTileEntity)) continue;
            ((ScreenTileEntity)te).setPower(false);
            ((ScreenTileEntity)te).setConnected(false);
        }
        this.connectedScreens.clear();
        this.func_70296_d();
    }

    public List<BlockPos> getConnectedScreens() {
        return this.connectedScreens;
    }
}

