/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.util.LazyOptional;

public class TimerTileEntity
extends LogicTileEntity
implements ITickableTileEntity,
TickOrderHandler.IOrderTicker {
    private boolean prevIn = false;
    private int timer = 0;
    @GuiValue
    private int delay = 20;
    @GuiValue(name="pauses")
    private boolean redstonePauses = false;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Timer").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_TIMER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/timer")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(TimerTileEntity::new));
    }

    public TimerTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_TIMER.get());
    }

    public int getDelay() {
        return this.delay;
    }

    public int getTimer() {
        return this.timer;
    }

    public boolean getRedstonePauses() {
        return this.redstonePauses;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
        this.func_70296_d();
    }

    public void setRedstonePauses(boolean redstonePauses) {
        this.redstonePauses = redstonePauses;
        if (redstonePauses && this.powerLevel > 0) {
            this.timer = this.delay;
        }
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
        }
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_3;
    }

    public void tickServer() {
        int newout;
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        this.func_70296_d();
        if (pulse) {
            this.timer = this.delay;
        }
        if (!this.redstonePauses || !this.prevIn) {
            --this.timer;
        }
        if (this.timer <= 0) {
            this.timer = this.delay;
            newout = 15;
        } else {
            newout = 0;
        }
        this.setRedstoneState(newout);
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.delay = info.func_74762_e("delay");
        this.redstonePauses = info.func_74767_n("redstonePauses");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("delay", this.delay);
        info.func_74757_a("redstonePauses", this.redstonePauses);
    }
}

