/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.Type;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class CounterTileEntity
extends LogicTileEntity {
    private boolean prevIn = false;
    private int counter = 1;
    @GuiValue
    public static final Value<CounterTileEntity, Integer> VALUE_COUNTER = Value.create((String)"counter", (Type)Type.INTEGER, CounterTileEntity::getCounter, CounterTileEntity::setCounter);
    @GuiValue
    private int current = 0;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Counter").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_COUNTER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public CounterTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_COUNTER.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/counter")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(CounterTileEntity::new));
    }

    public int getCounter() {
        return this.counter;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.current = 0;
        this.func_70296_d();
    }

    public void setCurrent(int current) {
        this.current = current;
        this.func_70296_d();
    }

    protected void update() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        int newout = 0;
        if (pulse) {
            ++this.current;
            if (this.current >= this.counter) {
                this.current = 0;
                newout = 15;
            }
            this.func_70296_d();
            this.setRedstoneState(newout);
        }
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.counter = info.func_74762_e("counter");
        if (this.counter == 0) {
            this.counter = 1;
        }
        this.current = info.func_74762_e("current");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("counter", this.counter);
        info.func_74768_a("current", this.current);
    }

    public void checkRedstone(World world, BlockPos pos) {
        super.checkRedstone(world, pos);
        this.update();
    }
}

