/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.core.model.PartBuilder;
import java.util.List;

public class ModelPart
implements IModel {
    private final List<PartBuilder.CuboidBuilder> cuboids;
    private int vertices;

    public ModelPart(List<PartBuilder.CuboidBuilder> cuboids) {
        this.cuboids = cuboids;
        this.vertices = 0;
        for (PartBuilder.CuboidBuilder cuboid : cuboids) {
            this.vertices += cuboid.vertices();
        }
    }

    public static PartBuilder builder(int sizeU, int sizeV) {
        return new PartBuilder(sizeU, sizeV);
    }

    @Override
    public void buffer(VecBuffer buffer) {
        for (PartBuilder.CuboidBuilder cuboid : this.cuboids) {
            cuboid.buffer(buffer);
        }
    }

    @Override
    public int vertexCount() {
        return this.vertices;
    }

    @Override
    public VertexFormat format() {
        return Formats.UNLIT_MODEL;
    }
}

