/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.versioned;

import com.jozufozu.flywheel.backend.gl.versioned.GlVersioned;
import com.jozufozu.flywheel.backend.gl.versioned.MapBufferRange;
import com.jozufozu.flywheel.backend.gl.versioned.RGPixelFormat;
import com.jozufozu.flywheel.backend.gl.versioned.framebuffer.Blit;
import com.jozufozu.flywheel.backend.gl.versioned.framebuffer.Framebuffer;
import com.jozufozu.flywheel.backend.gl.versioned.instancing.DrawInstanced;
import com.jozufozu.flywheel.backend.gl.versioned.instancing.InstancedArrays;
import com.jozufozu.flywheel.backend.gl.versioned.instancing.VertexArrayObject;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GlCompat {
    public final MapBufferRange mapBufferRange;
    public final VertexArrayObject vao;
    public final InstancedArrays instancedArrays;
    public final DrawInstanced drawInstanced;
    public final Blit blit;
    public final Framebuffer fbo;
    public final RGPixelFormat pixelFormat;

    public GlCompat(GLCapabilities caps) {
        this.mapBufferRange = GlCompat.getLatest(MapBufferRange.class, caps);
        this.vao = GlCompat.getLatest(VertexArrayObject.class, caps);
        this.instancedArrays = GlCompat.getLatest(InstancedArrays.class, caps);
        this.drawInstanced = GlCompat.getLatest(DrawInstanced.class, caps);
        this.blit = GlCompat.getLatest(Blit.class, caps);
        this.fbo = GlCompat.getLatest(Framebuffer.class, caps);
        this.pixelFormat = GlCompat.getLatest(RGPixelFormat.class, caps);
    }

    public boolean vertexArrayObjectsSupported() {
        return this.vao != VertexArrayObject.UNSUPPORTED;
    }

    public boolean instancedArraysSupported() {
        return this.instancedArrays != InstancedArrays.UNSUPPORTED;
    }

    public boolean drawInstancedSupported() {
        return this.drawInstanced != DrawInstanced.UNSUPPORTED;
    }

    public boolean fbosSupported() {
        return this.fbo != Framebuffer.UNSUPPORTED;
    }

    public boolean blitSupported() {
        return this.blit != Blit.UNSUPPORTED;
    }

    public static <V extends Enum<V>> V getLatest(Class<V> clazz, GLCapabilities caps) {
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        Enum last = constants[constants.length - 1];
        if (!((GlVersioned)((Object)last)).supported(caps)) {
            throw new IllegalStateException("");
        }
        return (V)Arrays.stream(constants).filter(it -> ((GlVersioned)((Object)it)).supported(caps)).findFirst().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeShaderSource(int glId, CharSequence source) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer sourceBuffer = MemoryUtil.memUTF8((CharSequence)source, (boolean)true);
            PointerBuffer pointers = stack.mallocPointer(1);
            pointers.put(sourceBuffer);
            GL20C.nglShaderSource((int)glId, (int)1, (long)pointers.address0(), (long)0L);
            APIUtil.apiArrayFree((long)pointers.address0(), (int)1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

