/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import org.lwjgl.glfw.GLFW;
import twistedgate.immersiveposts.ImmersivePosts;
import twistedgate.immersiveposts.common.IPOConfig;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.common.blocks.IPOBlockBase;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;
import twistedgate.immersiveposts.enums.EnumFlipState;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;

public class PostBaseBlock
extends IPOBlockBase
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty HIDDEN = BooleanProperty.func_177716_a((String)"hidden");
    private static final VoxelShape BASE_SIZE = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);

    private static AbstractBlock.Properties prop() {
        Material BaseMaterial = new Material(MaterialColor.field_151665_m, false, true, true, true, false, false, PushReaction.BLOCK);
        AbstractBlock.Properties prop = AbstractBlock.Properties.func_200945_a((Material)BaseMaterial).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(5.0f, 3.0f).func_226896_b_();
        return prop;
    }

    public PostBaseBlock() {
        super("postbase", PostBaseBlock.prop());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)HIDDEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        IPOContent.ITEMS.add((Item)new ItemPostBase(this, new Item.Properties().func_200916_a(ImmersivePosts.creativeTab)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HIDDEN, WATERLOGGED});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return !((Boolean)state.func_177229_b((Property)HIDDEN)).booleanValue() ? !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() : super.func_200123_i(state, reader, pos);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack;
        if (player.func_225608_bj_() && ((Boolean)state.func_177229_b((Property)HIDDEN)).booleanValue() && (stack = ((PostBaseTileEntity)world.func_175625_s(pos)).getStack()) != ItemStack.field_190927_a) {
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HIDDEN) == false && (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        FluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
        state = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (!((Boolean)state.func_177229_b((Property)HIDDEN)).booleanValue() && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((Property)HIDDEN) == false && super.func_204510_a(world, pos, state, fluid);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return IPOContent.TE_POSTBASE.func_200968_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)HIDDEN) != false ? VoxelShapes.func_197868_b() : BASE_SIZE;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof PostBaseTileEntity && ((PostBaseTileEntity)te).interact(state, worldIn, pos, playerIn, handIn)) {
            return ActionResultType.SUCCESS;
        }
        if (!worldIn.field_72995_K) {
            ItemStack held = playerIn.func_184614_ca();
            if (EnumPostMaterial.isValidItem(held)) {
                ItemStack tmp;
                BlockState aboveState;
                Block b;
                if (!worldIn.func_175623_d(pos.func_177972_a(Direction.UP)) && (b = (aboveState = worldIn.func_180495_p(pos.func_177972_a(Direction.UP))).func_177230_c()) instanceof PostBlock && !held.func_77969_a(tmp = ((PostBlock)b).postMaterial.getItemStack())) {
                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("immersiveposts.expectedlocal", new Object[]{tmp.func_200301_q()}), true);
                    return ActionResultType.SUCCESS;
                }
                for (int y = 1; y <= worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p()) - pos.func_177956_o(); ++y) {
                    BlockPos nPos = pos.func_177982_a(0, y, 0);
                    BlockState nState = worldIn.func_180495_p(nPos);
                    if (nState.func_177230_c() instanceof PostBlock) {
                        EnumPostType type = (EnumPostType)((Object)nState.func_177229_b(PostBlock.TYPE));
                        if (type != EnumPostType.POST && type != EnumPostType.POST_TOP && nState.func_177229_b(PostBlock.FLIPSTATE) == EnumFlipState.DOWN) {
                            return ActionResultType.SUCCESS;
                        }
                        nState = worldIn.func_180495_p(nPos.func_177972_a(Direction.UP));
                        if (nState.func_177230_c() instanceof PostBlock && (type = (EnumPostType)((Object)nState.func_177229_b(PostBlock.TYPE))) != EnumPostType.POST && type != EnumPostType.POST_TOP) {
                            return ActionResultType.SUCCESS;
                        }
                    }
                    if (worldIn.func_175623_d(nPos) || worldIn.func_180495_p(nPos).func_177230_c() == Blocks.field_150355_j) {
                        BlockState fb = (BlockState)EnumPostMaterial.getPostState(held).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.func_180495_p(nPos).func_177230_c() == Blocks.field_150355_j));
                        if (fb != null && !playerIn.func_233580_cy_().equals((Object)nPos) && worldIn.func_175656_a(nPos, fb.func_196956_a(null, null, (IWorld)worldIn, nPos, null)) && !playerIn.func_184812_l_()) {
                            held.func_190918_g(1);
                        }
                        return ActionResultType.SUCCESS;
                    }
                    if (worldIn.func_180495_p(nPos).func_177230_c() instanceof PostBlock) continue;
                    return ActionResultType.SUCCESS;
                }
            }
        } else {
            ItemStack held = playerIn.func_184614_ca();
            if (EnumPostMaterial.isValidItem(held)) {
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public static class ItemPostBase
    extends BlockItem {
        public ItemPostBase(Block block, Item.Properties properties) {
            super(block, properties);
            this.setRegistryName(block.getRegistryName());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
            if (this.isPressing(340) || this.isPressing(344)) {
                for (EnumPostMaterial t : EnumPostMaterial.values()) {
                    StringTextComponent typeName = new StringTextComponent("");
                    typeName.func_230529_a_(t.getItemStack().func_200301_q());
                    if (IPOConfig.MAIN.isEnabled(t)) {
                        typeName.func_240699_a_(TextFormatting.GREEN);
                    } else {
                        typeName.func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.STRIKETHROUGH});
                    }
                    tooltip.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)typeName));
                }
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"tooltip.postbase", (Object[])new Object[0])));
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private boolean isPressing(int key) {
            long window = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
            return GLFW.glfwGetKey((long)window, (int)key) == 1;
        }
    }
}

