/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.common.blocks.MetalFenceBlock;
import twistedgate.immersiveposts.common.blocks.PostBaseBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.common.items.IPOItemBase;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

@Mod.EventBusSubscriber(modid="immersiveposts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IPOContent {
    public static final Logger log = LogManager.getLogger((String)"immersiveposts/Stuff");
    public static final ArrayList<Block> BLOCKS = new ArrayList(0);
    public static final ArrayList<Item> ITEMS = new ArrayList(0);
    public static TileEntityType<PostBaseTileEntity> TE_POSTBASE;

    public static final void populate() {
        Blocks.post_Base = new PostBaseBlock();
        Blocks.Fences.iron = new MetalFenceBlock("iron");
        Blocks.Fences.gold = new MetalFenceBlock("gold");
        Blocks.Fences.copper = new MetalFenceBlock("copper");
        Blocks.Fences.lead = new MetalFenceBlock("lead");
        Blocks.Fences.silver = new MetalFenceBlock("silver");
        Blocks.Fences.nickel = new MetalFenceBlock("nickel");
        Blocks.Fences.constantan = new MetalFenceBlock("constantan");
        Blocks.Fences.electrum = new MetalFenceBlock("electrum");
        Blocks.Fences.uranium = new MetalFenceBlock("uranium");
        Blocks.Fences.ALL = new FenceBlock[]{Blocks.Fences.iron, Blocks.Fences.gold, Blocks.Fences.copper, Blocks.Fences.lead, Blocks.Fences.silver, Blocks.Fences.nickel, Blocks.Fences.constantan, Blocks.Fences.electrum, Blocks.Fences.uranium};
        EnumPostMaterial[] values = EnumPostMaterial.values();
        EnumMap<EnumPostMaterial, PostBlock> posts = new EnumMap<EnumPostMaterial, PostBlock>(EnumPostMaterial.class);
        EnumMap<EnumPostMaterial, HorizontalTrussBlock> trusses = new EnumMap<EnumPostMaterial, HorizontalTrussBlock>(EnumPostMaterial.class);
        for (EnumPostMaterial mat : values) {
            posts.put(mat, new PostBlock(mat));
            trusses.put(mat, new HorizontalTrussBlock(mat));
        }
        Blocks.Posts.MAP = posts;
        Blocks.HorizontalTruss.MAP = trusses;
        Items.rod_Gold = new IPOItemBase("stick_gold");
        Items.rod_Copper = new IPOItemBase("stick_copper");
        Items.rod_Lead = new IPOItemBase("stick_lead");
        Items.rod_Silver = new IPOItemBase("stick_silver");
        Items.rod_Nickel = new IPOItemBase("stick_nickel");
        Items.rod_Constantan = new IPOItemBase("stick_constantan");
        Items.rod_Electrum = new IPOItemBase("stick_electrum");
        Items.rod_Uranium = new IPOItemBase("stick_uranium");
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS) {
            try {
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
            catch (Throwable e) {
                log.error("Failed to register a block. ({})", (Object)block);
                throw e;
            }
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ITEMS) {
            try {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
            catch (Throwable e) {
                log.error("Failed to register an item. ({}, {})", (Object)item, (Object)item.getRegistryName());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        try {
            TE_POSTBASE = IPOContent.create("postbase", PostBaseTileEntity::new, Blocks.post_Base);
            event.getRegistry().register(TE_POSTBASE);
        }
        catch (Throwable e) {
            log.error("Failed to register postbase tileentity. {}", (Object)e.getMessage());
            throw e;
        }
    }

    private static <T extends TileEntity> TileEntityType<T> create(String name, Supplier<T> factory, Block ... validBlocks) {
        TileEntityType te = TileEntityType.Builder.func_223042_a(factory, (Block[])validBlocks).func_206865_a(null);
        te.setRegistryName(new ResourceLocation("immersiveposts", name));
        return te;
    }

    public static class Items {
        public static Item rod_Gold;
        public static Item rod_Copper;
        public static Item rod_Lead;
        public static Item rod_Silver;
        public static Item rod_Nickel;
        public static Item rod_Constantan;
        public static Item rod_Electrum;
        public static Item rod_Uranium;
    }

    public static class Blocks {
        public static PostBaseBlock post_Base;

        public static class HorizontalTruss {
            static EnumMap<EnumPostMaterial, HorizontalTrussBlock> MAP;

            public static HorizontalTrussBlock get(EnumPostMaterial material) {
                return MAP.get((Object)material);
            }
        }

        public static class Posts {
            static EnumMap<EnumPostMaterial, PostBlock> MAP;

            public static PostBlock get(EnumPostMaterial material) {
                return MAP.get((Object)material);
            }
        }

        public static class Fences {
            public static FenceBlock[] ALL;
            public static FenceBlock iron;
            public static FenceBlock gold;
            public static FenceBlock copper;
            public static FenceBlock lead;
            public static FenceBlock silver;
            public static FenceBlock nickel;
            public static FenceBlock constantan;
            public static FenceBlock electrum;
            public static FenceBlock uranium;
        }
    }
}

