/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.mods.rhino.mod.util.ChangeListener;
import dev.latvian.mods.rhino.mod.util.CompoundTagWrapper;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import dev.latvian.mods.rhino.mod.util.JsonUtils;
import dev.latvian.mods.rhino.util.ListLike;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.INBT;
import org.jetbrains.annotations.Nullable;

public class CollectionTagWrapper<T extends INBT>
implements ListLike<Object>,
JsonSerializable,
ChangeListener<INBT> {
    public final CollectionNBT<T> minecraftTag;
    public ChangeListener<INBT> listener;

    public CollectionTagWrapper(CollectionNBT<T> t) {
        this.minecraftTag = t;
    }

    @Override
    @Nullable
    public Object getLL(int index) {
        return CompoundTagWrapper.unwrap((INBT)this.minecraftTag.get(index), this);
    }

    @Override
    public void setLL(int index, Object value) {
        INBT t = CompoundTagWrapper.wrap(value);
        if (t != null) {
            this.minecraftTag.func_218659_a(index, t);
            if (this.listener != null) {
                this.listener.onChanged((INBT)this.minecraftTag);
            }
        }
    }

    @Override
    public int sizeLL() {
        return this.minecraftTag.size();
    }

    public void add(Object value) {
        INBT t = CompoundTagWrapper.wrap(value);
        if (t != null) {
            this.minecraftTag.add((Object)t);
            if (this.listener != null) {
                this.listener.onChanged((INBT)this.minecraftTag);
            }
        }
    }

    public void push(Object value) {
        this.add(value);
    }

    public JsonArray toJson() {
        JsonArray json = new JsonArray();
        for (INBT tag : this.minecraftTag) {
            JsonElement e = JsonUtils.of(CompoundTagWrapper.unwrap(tag, this));
            if (e.isJsonNull()) continue;
            json.add(e);
        }
        return json;
    }

    @Override
    public void onChanged(INBT o) {
        if (this.listener != null) {
            this.listener.onChanged((INBT)this.minecraftTag);
        }
    }
}

