/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjanitor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbjanitor.JERDimData;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.loot.LootContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.mutable.MutableLong;

public class JERScanner
implements Runnable {
    private static final Function<Block, MutableLong> BLOCK_TO_COUNT_FUNCTION = k -> new MutableLong(0L);
    public static JERScanner current;
    public final List<JERDimData> dimensions = new ArrayList<JERDimData>();
    public boolean stop;
    public final int height;
    public final int radius;
    public final int startX;
    public final int startZ;
    public final Set<Block> whitelist;
    public long blocksScanned;
    public Consumer<ITextComponent> callback;

    public JERScanner(int h, int r, int sx, int sz, Set<Block> w) {
        this.height = h;
        this.radius = r;
        this.startX = sx;
        this.startZ = sz;
        this.whitelist = w;
        this.blocksScanned = 0L;
        this.stop = true;
    }

    @Override
    public void run() {
        long diameter = 1L + (long)this.radius * 2L;
        long area = diameter * diameter;
        long blocks = area * 256L;
        long progress = 0L;
        long percent = 0L;
        for (JERDimData jERDimData : this.dimensions) {
            if (this.stop) {
                return;
            }
            jERDimData.distribution = new HashMap[this.height];
            for (int i = 0; i < this.height; ++i) {
                jERDimData.distribution[i] = new HashMap();
            }
            for (int x = -this.radius; x <= this.radius; ++x) {
                for (int z = -this.radius; z <= this.radius; ++z) {
                    if (this.stop) {
                        return;
                    }
                    int cx = this.startX + x;
                    int cz = this.startZ + z;
                    Chunk chunk = jERDimData.dimension.func_212866_a_(cx, cz);
                    for (int bx = 0; bx < 16; ++bx) {
                        for (int bz = 0; bz < 16; ++bz) {
                            int h = Math.min(this.height, chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING).func_202273_a(bx, bz));
                            for (int by = 0; by < h; ++by) {
                                BlockState state = chunk.func_180495_p(new BlockPos(cx * 16 + bx, by, cz * 16 + bz));
                                if (!(state.func_177230_c() instanceof AirBlock) && this.whitelist.contains(state.func_177230_c())) {
                                    jERDimData.distribution[by].computeIfAbsent(state.func_177230_c(), BLOCK_TO_COUNT_FUNCTION).increment();
                                }
                                ++this.blocksScanned;
                            }
                            ++progress;
                        }
                    }
                    long p = percent;
                    if (p == (percent = progress * 1000L / (blocks * (long)this.dimensions.size()))) continue;
                    this.callback.accept((ITextComponent)new StringTextComponent("JER Scanner is running [" + (double)percent / 10.0 + "%]"));
                }
            }
        }
        if (!this.stop) {
            JsonArray array = new JsonArray();
            for (JERDimData data : this.dimensions) {
                HashSet<Block> dimBlocks = new HashSet<Block>();
                for (int y = 0; y < this.height; ++y) {
                    dimBlocks.addAll(data.distribution[y].keySet());
                }
                LootContext.Builder lootContext = new LootContext.Builder(data.dimension).func_216023_a(data.dimension.field_73012_v).func_186469_a(1.0f);
                for (Block block : dimBlocks) {
                    StringBuilder sb = new StringBuilder();
                    for (int y = 0; y < this.height; ++y) {
                        if (y > 0) {
                            sb.append(';');
                        }
                        sb.append(y);
                        sb.append(',');
                        MutableLong m = data.distribution[y].get(block);
                        sb.append(m == null ? "0.0" : Double.toString(m.getValue().doubleValue() / (double)blocks));
                    }
                    JsonObject json = new JsonObject();
                    json.addProperty("block", Registry.field_212618_g.func_177774_c((Object)block).toString());
                    json.addProperty("silktouch", Boolean.valueOf(false));
                    json.addProperty("dim", data.dimension.func_234923_W_().func_240901_a_().toString());
                    json.addProperty("distrib", sb.toString());
                    array.add((JsonElement)json);
                }
            }
            try {
                Files.write(FMLPaths.CONFIGDIR.get().resolve("world-gen.json"), Collections.singleton(array.toString()), new OpenOption[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        current = null;
    }

    public void stop() {
        this.stop = true;
    }
}

