/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjanitor;

import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class FTBJanitorConfig {
    private static FTBJanitorConfig instance;
    public final SNBTConfig config;
    public final BooleanValue logTagCreation;
    public final BooleanValue logNetworkErrors;
    public final BooleanValue disableRecipeShrinking;
    public final BooleanValue printReloadStacktrace;
    public final BooleanValue printCommandStacktrace;
    public final BooleanValue lazyDFU;
    public final IntValue refreshBiomes;

    public static FTBJanitorConfig get() {
        if (instance == null) {
            instance = new FTBJanitorConfig();
        }
        return instance;
    }

    private FTBJanitorConfig() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("ftbjanitor.snbt");
        this.config = SNBTConfig.create((String)"ftbjanitor");
        this.logTagCreation = (BooleanValue)this.config.getBoolean("logTagCreation", false).comment(new String[]{"Prints new tag creation in console"});
        this.logNetworkErrors = (BooleanValue)this.config.getBoolean("logNetworkErrors", false).comment(new String[]{"Prints network errors in normal log rather than debug"});
        this.disableRecipeShrinking = (BooleanValue)this.config.getBoolean("disableRecipeShrinking", false).comment(new String[]{"Vanilla shrinks recipe patterns to try to optimise them, but it's sometimes breaking some modded recipes"});
        this.printReloadStacktrace = (BooleanValue)this.config.getBoolean("printReloadStacktrace", false).comment(new String[]{"Print whenever a reload is triggered"});
        this.printCommandStacktrace = (BooleanValue)this.config.getBoolean("printCommandStacktrace", false).comment(new String[]{"Print whenever a command is run. Used to catch /reload startup mods"});
        this.lazyDFU = (BooleanValue)this.config.getBoolean("lazyDFU", true).comment(new String[]{"Enables lazy DataFixerUpper"});
        this.refreshBiomes = (IntValue)this.config.getInt("refreshBiomes", 0, 0, Integer.MAX_VALUE).comment(new String[]{"Increment this number every time you want to reset biomes in world"});
        this.config.load(path);
    }
}

