/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess {
    private IPocketUpgrade upgrade;
    private Entity entity;
    private ItemStack stack;

    public PocketServerComputer(World world, int computerID, String label, int instanceID, ComputerFamily family) {
        super(world, computerID, label, instanceID, family, ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        Entity entity = this.entity;
        if (entity == null || this.stack == null || !entity.func_70089_S()) {
            return null;
        }
        if (entity instanceof PlayerEntity) {
            PlayerInventory inventory = ((PlayerEntity)entity).field_71071_by;
            return inventory.field_70462_a.contains((Object)this.stack) || inventory.field_184439_c.contains((Object)this.stack) ? entity : null;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.func_184614_ca() == this.stack || living.func_184592_cb() == this.stack ? entity : null;
        }
        return null;
    }

    @Override
    public int getColour() {
        return IColouredItem.getColourBasic(this.stack);
    }

    @Override
    public void setColour(int colour) {
        IColouredItem.setColourBasic(this.stack, colour);
        this.updateUpgradeNBTData();
    }

    @Override
    public int getLight() {
        CompoundNBT tag = this.getUserData();
        return tag.func_150297_b("Light", 99) ? tag.func_74762_e("Light") : -1;
    }

    @Override
    public void setLight(int colour) {
        CompoundNBT tag = this.getUserData();
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (!tag.func_150297_b("Light", 99) || tag.func_74762_e("Light") != colour) {
                tag.func_74768_a("Light", colour);
                this.updateUserData();
            }
        } else if (tag.func_150297_b("Light", 99)) {
            tag.func_82580_o("Light");
            this.updateUserData();
        }
    }

    @Override
    @Nonnull
    public CompoundNBT getUpgradeNBTData() {
        return ItemPocketComputer.getUpgradeInfo(this.stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        if (this.entity instanceof PlayerEntity) {
            ((PlayerEntity)this.entity).field_71071_by.func_70296_d();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.createPeripheral(this);
        this.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, IPeripheral> getUpgrades() {
        return this.upgrade == null ? Collections.emptyMap() : Collections.singletonMap(this.upgrade.getUpgradeID(), this.getPeripheral(ComputerSide.BACK));
    }

    public IPocketUpgrade getUpgrade() {
        return this.upgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgrade(IPocketUpgrade upgrade) {
        if (this.upgrade == upgrade) {
            return;
        }
        PocketServerComputer pocketServerComputer = this;
        synchronized (pocketServerComputer) {
            ItemPocketComputer.setUpgrade(this.stack, upgrade);
            this.updateUpgradeNBTData();
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    public synchronized void updateValues(Entity entity, @Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        if (entity != null) {
            this.setWorld(entity.func_130014_f_());
            this.setPosition(entity.func_233580_cy_());
        }
        if (entity != this.entity && entity instanceof ServerPlayerEntity) {
            this.markTerminalChanged();
        }
        this.entity = entity;
        this.stack = stack;
        if (this.upgrade != upgrade) {
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    @Override
    public void broadcastState(boolean force) {
        super.broadcastState(force);
        if ((this.hasTerminalChanged() || force) && this.entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)this.entity;
            if (player.field_71135_a != null && !this.isInteracting((PlayerEntity)player)) {
                NetworkHandler.sendToPlayer((PlayerEntity)player, this.createTerminalPacket());
            }
        }
    }
}

