/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.Expander;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.monitor.MonitorPeripheral;
import dan200.computercraft.shared.peripheral.monitor.MonitorState;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.XYPair;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileMonitor
extends TileGeneric {
    public static final double RENDER_BORDER = 0.125;
    public static final double RENDER_MARGIN = 0.03125;
    public static final double RENDER_PIXEL_SCALE = 0.015625;
    private static final String NBT_X = "XIndex";
    private static final String NBT_Y = "YIndex";
    private static final String NBT_WIDTH = "Width";
    private static final String NBT_HEIGHT = "Height";
    private final boolean advanced;
    private ServerMonitor serverMonitor;
    private ClientMonitor clientMonitor;
    private MonitorPeripheral peripheral;
    private LazyOptional<IPeripheral> peripheralCap;
    private final Set<IComputerAccess> computers = new HashSet<IComputerAccess>();
    private boolean needsUpdate = false;
    private boolean needsValidating = false;
    private boolean destroyed = false;
    boolean enqueued;
    TerminalState cached;
    private int width = 1;
    private int height = 1;
    private int xIndex = 0;
    private int yIndex = 0;

    public TileMonitor(TileEntityType<? extends TileMonitor> type, boolean advanced) {
        super(type);
        this.advanced = advanced;
    }

    public void onLoad() {
        super.onLoad();
        this.needsValidating = true;
        TickScheduler.schedule(this);
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (!this.func_145831_w().field_72995_K) {
            this.contractNeighbours();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
    }

    @Override
    @Nonnull
    public ActionResultType onActivate(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!player.func_213453_ef() && this.getFront() == hit.func_216354_b()) {
            if (!this.func_145831_w().field_72995_K) {
                this.monitorTouched((float)(hit.func_216347_e().field_72450_a - (double)hit.func_216350_a().func_177958_n()), (float)(hit.func_216347_e().field_72448_b - (double)hit.func_216350_a().func_177956_o()), (float)(hit.func_216347_e().field_72449_c - (double)hit.func_216350_a().func_177952_p()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a(NBT_X, this.xIndex);
        tag.func_74768_a(NBT_Y, this.yIndex);
        tag.func_74768_a(NBT_WIDTH, this.width);
        tag.func_74768_a(NBT_HEIGHT, this.height);
        return super.func_189515_b(tag);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.xIndex = nbt.func_74762_e(NBT_X);
        this.yIndex = nbt.func_74762_e(NBT_Y);
        this.width = nbt.func_74762_e(NBT_WIDTH);
        this.height = nbt.func_74762_e(NBT_HEIGHT);
    }

    @Override
    public void blockTick() {
        if (this.needsValidating) {
            this.needsValidating = false;
            this.validate();
        }
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.expand();
        }
        if (this.xIndex != 0 || this.yIndex != 0 || this.serverMonitor == null) {
            return;
        }
        this.serverMonitor.clearChanged();
        if (this.serverMonitor.pollResized()) {
            this.eachComputer(c -> c.queueEvent("monitor_resize", c.getAttachmentName()));
        }
        if (this.serverMonitor.pollTerminalChanged()) {
            MonitorWatcher.enqueue(this);
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.peripheralCap = CapabilityUtil.invalidate(this.peripheralCap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            this.createServerMonitor();
            if (this.peripheral == null) {
                this.peripheral = new MonitorPeripheral(this);
            }
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> this.peripheral);
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public ServerMonitor getCachedServerMonitor() {
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor getServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        TileMonitor origin = this.getOrigin().getMonitor();
        if (origin == null) {
            return null;
        }
        this.serverMonitor = origin.serverMonitor;
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor createServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        if (this.xIndex == 0 && this.yIndex == 0) {
            this.serverMonitor = new ServerMonitor(this.advanced, this);
            this.serverMonitor.rebuild();
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                    if (monitor == null) continue;
                    monitor.serverMonitor = this.serverMonitor;
                }
            }
            return this.serverMonitor;
        }
        BlockPos pos = this.func_174877_v();
        TileEntity te = this.field_145850_b.func_175625_s(this.toWorldPos(0, 0));
        if (!(te instanceof TileMonitor)) {
            return null;
        }
        this.serverMonitor = ((TileMonitor)te).createServerMonitor();
        return this.serverMonitor;
    }

    @Nullable
    public ClientMonitor getClientMonitor() {
        if (this.clientMonitor != null) {
            return this.clientMonitor;
        }
        BlockPos pos = this.func_174877_v();
        TileEntity te = this.field_145850_b.func_175625_s(this.toWorldPos(0, 0));
        if (!(te instanceof TileMonitor)) {
            return null;
        }
        this.clientMonitor = ((TileMonitor)te).clientMonitor;
        return this.clientMonitor;
    }

    @Override
    protected void writeDescription(@Nonnull CompoundNBT nbt) {
        super.writeDescription(nbt);
        nbt.func_74768_a(NBT_X, this.xIndex);
        nbt.func_74768_a(NBT_Y, this.yIndex);
        nbt.func_74768_a(NBT_WIDTH, this.width);
        nbt.func_74768_a(NBT_HEIGHT, this.height);
    }

    @Override
    protected final void readDescription(@Nonnull CompoundNBT nbt) {
        super.readDescription(nbt);
        int oldXIndex = this.xIndex;
        int oldYIndex = this.yIndex;
        this.xIndex = nbt.func_74762_e(NBT_X);
        this.yIndex = nbt.func_74762_e(NBT_Y);
        this.width = nbt.func_74762_e(NBT_WIDTH);
        this.height = nbt.func_74762_e(NBT_HEIGHT);
        if (oldXIndex != this.xIndex || oldYIndex != this.yIndex) {
            if (oldXIndex == 0 && oldYIndex == 0 && this.clientMonitor != null) {
                this.clientMonitor.destroy();
            }
            this.clientMonitor = null;
        }
        if (this.xIndex == 0 && this.yIndex == 0 && this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this.advanced, this);
        }
    }

    public final void read(TerminalState state) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            ComputerCraft.log.warn("Receiving monitor state for non-origin terminal at {}", (Object)this.func_174877_v());
            return;
        }
        if (this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this.advanced, this);
        }
        this.clientMonitor.read(state);
    }

    private void updateBlockState() {
        this.func_145831_w().func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a(BlockMonitor.STATE, (Comparable)((Object)MonitorEdgeState.fromConnections(this.yIndex < this.height - 1, this.yIndex > 0, this.xIndex > 0, this.xIndex < this.width - 1))), 2);
    }

    public Direction getDirection() {
        BlockState state = this.func_195044_w();
        return state.func_235901_b_((Property)BlockMonitor.FACING) ? (Direction)state.func_177229_b((Property)BlockMonitor.FACING) : Direction.NORTH;
    }

    public Direction getOrientation() {
        BlockState state = this.func_195044_w();
        return state.func_235901_b_((Property)BlockMonitor.ORIENTATION) ? (Direction)state.func_177229_b((Property)BlockMonitor.ORIENTATION) : Direction.NORTH;
    }

    public Direction getFront() {
        Direction orientation = this.getOrientation();
        return orientation == Direction.NORTH ? this.getDirection() : orientation;
    }

    public Direction getRight() {
        return this.getDirection().func_176735_f();
    }

    public Direction getDown() {
        Direction orientation = this.getOrientation();
        if (orientation == Direction.NORTH) {
            return Direction.UP;
        }
        return orientation == Direction.DOWN ? this.getDirection() : this.getDirection().func_176734_d();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    boolean isCompatible(TileMonitor other) {
        return !other.destroyed && this.advanced == other.advanced && this.getOrientation() == other.getOrientation() && this.getDirection() == other.getDirection();
    }

    @Nonnull
    private MonitorState getLoadedMonitor(int x, int y) {
        if (x == this.xIndex && y == this.yIndex) {
            return MonitorState.present(this);
        }
        BlockPos pos = this.toWorldPos(x, y);
        World world = this.func_145831_w();
        if (world == null || !world.isAreaLoaded(pos, 0)) {
            return MonitorState.UNLOADED;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileMonitor)) {
            return MonitorState.MISSING;
        }
        TileMonitor monitor = (TileMonitor)tile;
        return this.isCompatible(monitor) ? MonitorState.present(monitor) : MonitorState.MISSING;
    }

    private MonitorState getOrigin() {
        return this.getLoadedMonitor(0, 0);
    }

    BlockPos toWorldPos(int x, int y) {
        if (this.xIndex == x && this.yIndex == y) {
            return this.func_174877_v();
        }
        return this.func_174877_v().func_177967_a(this.getRight(), -this.xIndex + x).func_177967_a(this.getDown(), -this.yIndex + y);
    }

    void resize(int width, int height) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            this.serverMonitor = null;
        }
        this.xIndex = 0;
        this.yIndex = 0;
        this.width = width;
        this.height = height;
        boolean needsTerminal = false;
        block0: for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null || monitor.peripheral == null) continue;
                needsTerminal = true;
                break block0;
            }
        }
        if (needsTerminal) {
            if (this.serverMonitor == null) {
                this.serverMonitor = new ServerMonitor(this.advanced, this);
            }
        } else {
            this.serverMonitor = null;
        }
        if (this.serverMonitor != null) {
            this.serverMonitor.rebuild();
        }
        BlockPos pos = this.func_174877_v();
        Direction down = this.getDown();
        Direction right = this.getRight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                TileEntity other = this.func_145831_w().func_175625_s(pos.func_177967_a(right, x).func_177967_a(down, y));
                if (!(other instanceof TileMonitor) || !this.isCompatible((TileMonitor)other)) continue;
                TileMonitor monitor = (TileMonitor)other;
                monitor.xIndex = x;
                monitor.yIndex = y;
                monitor.width = width;
                monitor.height = height;
                monitor.serverMonitor = this.serverMonitor;
                monitor.needsValidating = false;
                monitor.needsUpdate = false;
                monitor.updateBlockState();
                monitor.updateBlock();
            }
        }
    }

    void updateNeighborsDeferred() {
        this.needsUpdate = true;
    }

    void expand() {
        TileMonitor monitor = this.getOrigin().getMonitor();
        if (monitor != null && monitor.xIndex == 0 && monitor.yIndex == 0) {
            new Expander(monitor).expand();
        }
    }

    private void contractNeighbours() {
        if (this.width == 1 && this.height == 1) {
            return;
        }
        BlockPos pos = this.func_174877_v();
        Direction down = this.getDown();
        Direction right = this.getRight();
        BlockPos origin = this.toWorldPos(0, 0);
        TileMonitor toLeft = null;
        TileMonitor toAbove = null;
        TileMonitor toRight = null;
        TileMonitor toBelow = null;
        if (this.xIndex > 0) {
            toLeft = this.tryResizeAt(pos.func_177967_a(right, -this.xIndex), this.xIndex, 1);
        }
        if (this.yIndex > 0) {
            toAbove = this.tryResizeAt(origin, this.width, this.yIndex);
        }
        if (this.xIndex < this.width - 1) {
            toRight = this.tryResizeAt(pos.func_177967_a(right, 1), this.width - this.xIndex - 1, 1);
        }
        if (this.yIndex < this.height - 1) {
            toBelow = this.tryResizeAt(origin.func_177967_a(down, this.yIndex + 1), this.width, this.height - this.yIndex - 1);
        }
        if (toLeft != null) {
            toLeft.expand();
        }
        if (toAbove != null) {
            toAbove.expand();
        }
        if (toRight != null) {
            toRight.expand();
        }
        if (toBelow != null) {
            toBelow.expand();
        }
    }

    @Nullable
    private TileMonitor tryResizeAt(BlockPos pos, int width, int height) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile instanceof TileMonitor && this.isCompatible((TileMonitor)tile)) {
            TileMonitor monitor = (TileMonitor)tile;
            monitor.resize(width, height);
            return monitor;
        }
        return null;
    }

    private boolean checkMonitorAt(int xIndex, int yIndex) {
        MonitorState state = this.getLoadedMonitor(xIndex, yIndex);
        if (state.isMissing()) {
            return false;
        }
        TileMonitor monitor = state.getMonitor();
        if (monitor == null) {
            return true;
        }
        return monitor.xIndex == xIndex && monitor.yIndex == yIndex && monitor.width == this.width && monitor.height == this.height;
    }

    private void validate() {
        if (this.xIndex == 0 && this.yIndex == 0 && this.width == 1 && this.height == 1) {
            return;
        }
        if (this.xIndex >= 0 && this.xIndex <= this.width && this.width > 0 && this.width <= ComputerCraft.monitorWidth && this.yIndex >= 0 && this.yIndex <= this.height && this.height > 0 && this.height <= ComputerCraft.monitorHeight && this.checkMonitorAt(0, 0) && this.checkMonitorAt(0, this.height - 1) && this.checkMonitorAt(this.width - 1, 0) && this.checkMonitorAt(this.width - 1, this.height - 1)) {
            return;
        }
        ComputerCraft.log.warn("Monitor is malformed, resetting to 1x1.");
        this.resize(1, 1);
        this.needsUpdate = true;
    }

    private void monitorTouched(float xPos, float yPos, float zPos) {
        XYPair pair = XYPair.of(xPos, yPos, zPos, this.getDirection(), this.getOrientation()).add(this.xIndex, this.height - this.yIndex - 1);
        if ((double)pair.x > (double)this.width - 0.125 || (double)pair.y > (double)this.height - 0.125 || (double)pair.x < 0.125 || (double)pair.y < 0.125) {
            return;
        }
        ServerMonitor serverTerminal = this.getServerMonitor();
        if (serverTerminal == null || !serverTerminal.isColour()) {
            return;
        }
        Terminal originTerminal = serverTerminal.getTerminal();
        if (originTerminal == null) {
            return;
        }
        double xCharWidth = ((double)this.width - 0.3125) / (double)originTerminal.getWidth();
        double yCharHeight = ((double)this.height - 0.3125) / (double)originTerminal.getHeight();
        int xCharPos = (int)Math.min((double)originTerminal.getWidth(), Math.max(((double)pair.x - 0.125 - 0.03125) / xCharWidth + 1.0, 1.0));
        int yCharPos = (int)Math.min((double)originTerminal.getHeight(), Math.max(((double)pair.y - 0.125 - 0.03125) / yCharHeight + 1.0, 1.0));
        this.eachComputer(c -> c.queueEvent("monitor_touch", c.getAttachmentName(), xCharPos, yCharPos));
    }

    private void eachComputer(Consumer<IComputerAccess> fun) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                TileMonitor monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null) continue;
                for (IComputerAccess computer : monitor.computers) {
                    fun.accept(computer);
                }
            }
        }
    }

    void addComputer(IComputerAccess computer) {
        this.computers.add(computer);
    }

    void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos startPos = this.toWorldPos(0, 0);
        BlockPos endPos = this.toWorldPos(this.width, this.height);
        return new AxisAlignedBB((double)Math.min(startPos.func_177958_n(), endPos.func_177958_n()), (double)Math.min(startPos.func_177956_o(), endPos.func_177956_o()), (double)Math.min(startPos.func_177952_p(), endPos.func_177952_p()), (double)(Math.max(startPos.func_177958_n(), endPos.func_177958_n()) + 1), (double)(Math.max(startPos.func_177956_o(), endPos.func_177956_o()) + 1), (double)(Math.max(startPos.func_177952_p(), endPos.func_177952_p()) + 1));
    }

    public double func_145833_n() {
        return ComputerCraft.monitorDistanceSq;
    }
}

