/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import javax.annotation.Nonnull;
import org.lwjgl.opengl.GL;

public enum MonitorRenderer {
    BEST,
    TBO,
    VBO;

    private static boolean initialised;
    private static boolean textureBuffer;

    @Nonnull
    public static MonitorRenderer current() {
        MonitorRenderer current = ComputerCraft.monitorRenderer;
        switch (current) {
            case BEST: {
                return MonitorRenderer.best();
            }
            case TBO: {
                MonitorRenderer.checkCapabilities();
                if (!textureBuffer) {
                    ComputerCraft.log.warn("Texture buffers are not supported on your graphics card. Falling back to default.");
                    ComputerCraft.monitorRenderer = BEST;
                    return MonitorRenderer.best();
                }
                return TBO;
            }
        }
        return current;
    }

    private static MonitorRenderer best() {
        MonitorRenderer.checkCapabilities();
        return textureBuffer ? TBO : VBO;
    }

    private static void checkCapabilities() {
        if (initialised) {
            return;
        }
        textureBuffer = GL.getCapabilities().OpenGL31;
        initialised = true;
    }

    static {
        initialised = false;
        textureBuffer = false;
    }
}

