/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import java.util.Objects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

class Expander {
    private final World level;
    private final Direction down;
    private final Direction right;
    private TileMonitor origin;
    private int width;
    private int height;

    Expander(TileMonitor origin) {
        this.origin = origin;
        this.width = origin.getWidth();
        this.height = origin.getHeight();
        this.level = Objects.requireNonNull(origin.func_145831_w(), "level cannot be null");
        this.down = origin.getDown();
        this.right = origin.getRight();
    }

    void expand() {
        int changedCount = 0;
        int changeLimit = ComputerCraft.monitorWidth * ComputerCraft.monitorHeight + 1;
        while (this.expandIn(true, false) || this.expandIn(true, true) || this.expandIn(false, false) || this.expandIn(false, true)) {
            if (++changedCount <= changeLimit) continue;
            ComputerCraft.log.error("Monitor has grown too much. This suggests there's an empty monitor in the world.");
            break;
        }
        if (changedCount > 0) {
            this.origin.resize(this.width, this.height);
        }
    }

    private boolean expandIn(boolean useXAxis, boolean isPositive) {
        BlockPos pos = this.origin.func_174877_v();
        int height = this.height;
        int width = this.width;
        int otherOffset = isPositive ? (useXAxis ? width : height) : -1;
        BlockPos otherPos = useXAxis ? pos.func_177967_a(this.right, otherOffset) : pos.func_177967_a(this.down, otherOffset);
        TileEntity other = this.level.func_175625_s(otherPos);
        if (!(other instanceof TileMonitor) || !this.origin.isCompatible((TileMonitor)other)) {
            return false;
        }
        TileMonitor otherMonitor = (TileMonitor)other;
        if (useXAxis) {
            if (otherMonitor.getYIndex() != 0 || otherMonitor.getHeight() != height) {
                return false;
            }
            if ((width += otherMonitor.getWidth()) > ComputerCraft.monitorWidth) {
                return false;
            }
        } else {
            if (otherMonitor.getXIndex() != 0 || otherMonitor.getWidth() != width) {
                return false;
            }
            if ((height += otherMonitor.getHeight()) > ComputerCraft.monitorHeight) {
                return false;
            }
        }
        if (!isPositive) {
            TileEntity otherOrigin = this.level.func_175625_s(otherMonitor.toWorldPos(0, 0));
            if (otherOrigin == null || !this.origin.isCompatible((TileMonitor)otherOrigin)) {
                return false;
            }
            this.origin = (TileMonitor)otherOrigin;
        }
        this.width = width;
        this.height = height;
        return true;
    }
}

