/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.diskdrive.BlockDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.ContainerDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDrivePeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.DefaultInventory;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RecordUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public final class TileDiskDrive
extends TileGeneric
implements DefaultInventory,
ITickableTileEntity,
INameable,
INamedContainerProvider {
    private static final String NBT_NAME = "CustomName";
    private static final String NBT_ITEM = "Item";
    ITextComponent customName;
    private final Map<IComputerAccess, MountInfo> computers = new HashMap<IComputerAccess, MountInfo>();
    @Nonnull
    private ItemStack diskStack = ItemStack.field_190927_a;
    private LazyOptional<IItemHandlerModifiable> itemHandlerCap;
    private LazyOptional<IPeripheral> peripheralCap;
    private IMount diskMount = null;
    private boolean recordQueued = false;
    private boolean recordPlaying = false;
    private boolean restartRecord = false;
    private boolean ejectQueued;

    public TileDiskDrive(TileEntityType<TileDiskDrive> type) {
        super(type);
    }

    @Override
    public void destroy() {
        this.ejectContents(true);
        if (this.recordPlaying) {
            this.stopRecord();
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCap = CapabilityUtil.invalidate(this.itemHandlerCap);
        this.peripheralCap = CapabilityUtil.invalidate(this.peripheralCap);
    }

    @Override
    @Nonnull
    public ActionResultType onActivate(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_213453_ef()) {
            ItemStack disk = player.func_184586_b(hand);
            if (disk.func_190926_b()) {
                return ActionResultType.PASS;
            }
            if (!this.func_145831_w().field_72995_K && this.func_70301_a(0).func_190926_b() && MediaProviders.get(disk) != null) {
                this.setDiskStack(disk);
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            return ActionResultType.SUCCESS;
        }
        if (!this.func_145831_w().field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return ActionResultType.SUCCESS;
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BlockDiskDrive.FACING);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        IFormattableTextComponent iFormattableTextComponent = this.customName = nbt.func_74764_b(NBT_NAME) ? ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i(NBT_NAME)) : null;
        if (nbt.func_74764_b(NBT_ITEM)) {
            CompoundNBT item = nbt.func_74775_l(NBT_ITEM);
            this.diskStack = ItemStack.func_199557_a((CompoundNBT)item);
            this.diskMount = null;
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        if (this.customName != null) {
            nbt.func_74778_a(NBT_NAME, ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        if (!this.diskStack.func_190926_b()) {
            CompoundNBT item = new CompoundNBT();
            this.diskStack.func_77955_b(item);
            nbt.func_218657_a(NBT_ITEM, (INBT)item);
        }
        return super.func_189515_b(nbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        if (this.ejectQueued) {
            this.ejectContents(false);
            this.ejectQueued = false;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            if (!this.field_145850_b.field_72995_K && this.recordPlaying != this.recordQueued || this.restartRecord) {
                this.restartRecord = false;
                if (this.recordQueued) {
                    SoundEvent record;
                    IMedia contents = this.getDiskMedia();
                    SoundEvent soundEvent = record = contents != null ? contents.getAudio(this.diskStack) : null;
                    if (record != null) {
                        this.recordPlaying = true;
                        this.playRecord();
                    } else {
                        this.recordQueued = false;
                    }
                } else {
                    this.stopRecord();
                    this.recordPlaying = false;
                }
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.diskStack.func_190926_b();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.diskStack;
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        ItemStack result = this.diskStack;
        this.diskStack = ItemStack.field_190927_a;
        this.diskMount = null;
        return result;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        if (this.diskStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.diskStack.func_190916_E() <= count) {
            ItemStack disk = this.diskStack;
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return disk;
        }
        ItemStack part = this.diskStack.func_77979_a(count);
        this.func_70299_a(slot, this.diskStack.func_190926_b() ? ItemStack.field_190927_a : this.diskStack);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        if (this.func_145831_w().field_72995_K) {
            this.diskStack = stack;
            this.diskMount = null;
            this.func_70296_d();
            return;
        }
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            Set<IComputerAccess> computers;
            if (InventoryUtil.areItemsStackable(stack, this.diskStack)) {
                this.diskStack = stack;
                return;
            }
            if (!this.diskStack.func_190926_b()) {
                computers = this.computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.unmountDisk(computer);
                }
            }
            if (this.recordPlaying) {
                this.stopRecord();
                this.recordPlaying = false;
                this.recordQueued = false;
            }
            this.diskStack = stack;
            this.diskMount = null;
            this.func_70296_d();
            if (!this.diskStack.func_190926_b()) {
                computers = this.computers.keySet();
                for (IComputerAccess computer : computers) {
                    this.mountDisk(computer);
                }
            }
        }
    }

    public void func_70296_d() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateBlockState();
        }
        super.func_70296_d();
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        return this.isUsable(player, false);
    }

    public void func_174888_l() {
        this.func_70299_a(0, ItemStack.field_190927_a);
    }

    @Nonnull
    ItemStack getDiskStack() {
        return this.func_70301_a(0);
    }

    void setDiskStack(@Nonnull ItemStack stack) {
        this.func_70299_a(0, stack);
    }

    private IMedia getDiskMedia() {
        return MediaProviders.get(this.getDiskStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDiskMountPath(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            MountInfo info = this.computers.get(computer);
            return info != null ? info.mountPath : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.computers.put(computer, new MountInfo());
            this.mountDisk(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmount(IComputerAccess computer) {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.unmountDisk(computer);
            this.computers.remove(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void playDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            IMedia media = this.getDiskMedia();
            if (media != null && media.getAudioTitle(this.diskStack) != null) {
                this.recordQueued = true;
                this.restartRecord = this.recordPlaying;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDiskAudio() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.recordQueued = false;
            this.restartRecord = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ejectDisk() {
        TileDiskDrive tileDiskDrive = this;
        synchronized (tileDiskDrive) {
            this.ejectQueued = true;
        }
    }

    private synchronized void mountDisk(IComputerAccess computer) {
        if (!this.diskStack.func_190926_b()) {
            MountInfo info = this.computers.get(computer);
            IMedia contents = this.getDiskMedia();
            if (contents != null) {
                if (this.diskMount == null) {
                    this.diskMount = contents.createDataMount(this.diskStack, this.func_145831_w());
                }
                if (this.diskMount != null) {
                    if (this.diskMount instanceof IWritableMount) {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mountWritable(n == 1 ? "disk" : "disk" + n, (IWritableMount)this.diskMount);
                            ++n;
                        }
                    } else {
                        int n = 1;
                        while (info.mountPath == null) {
                            info.mountPath = computer.mount(n == 1 ? "disk" : "disk" + n, this.diskMount);
                            ++n;
                        }
                    }
                } else {
                    info.mountPath = null;
                }
            }
            computer.queueEvent("disk", computer.getAttachmentName());
        }
    }

    private synchronized void unmountDisk(IComputerAccess computer) {
        if (!this.diskStack.func_190926_b()) {
            MountInfo info = this.computers.get(computer);
            assert (info != null);
            if (info.mountPath != null) {
                computer.unmount(info.mountPath);
                info.mountPath = null;
            }
            computer.queueEvent("disk_eject", computer.getAttachmentName());
        }
    }

    private void updateBlockState() {
        if (this.field_145846_f || this.field_145850_b == null) {
            return;
        }
        if (!this.diskStack.func_190926_b()) {
            IMedia contents = this.getDiskMedia();
            this.updateBlockState(contents != null ? DiskDriveState.FULL : DiskDriveState.INVALID);
        } else {
            this.updateBlockState(DiskDriveState.EMPTY);
        }
    }

    private void updateBlockState(DiskDriveState state) {
        BlockState blockState = this.func_195044_w();
        if (blockState.func_177229_b(BlockDiskDrive.STATE) == state) {
            return;
        }
        this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)blockState.func_206870_a(BlockDiskDrive.STATE, (Comparable)((Object)state)));
    }

    private synchronized void ejectContents(boolean destroyed) {
        if (this.func_145831_w().field_72995_K || this.diskStack.func_190926_b()) {
            return;
        }
        ItemStack disks = this.diskStack;
        this.setDiskStack(ItemStack.field_190927_a);
        int xOff = 0;
        int zOff = 0;
        if (!destroyed) {
            Direction dir = this.getDirection();
            xOff = dir.func_82601_c();
            zOff = dir.func_82599_e();
        }
        BlockPos pos = this.func_174877_v();
        double x = (double)pos.func_177958_n() + 0.5 + (double)xOff * 0.5;
        double y = (double)pos.func_177956_o() + 0.75;
        double z = (double)pos.func_177952_p() + 0.5 + (double)zOff * 0.5;
        ItemEntity entityitem = new ItemEntity(this.func_145831_w(), x, y, z, disks);
        entityitem.func_213293_j((double)xOff * 0.15, 0.0, (double)zOff * 0.15);
        this.func_145831_w().func_217376_c((Entity)entityitem);
        if (!destroyed) {
            this.func_145831_w().func_175669_a(1000, this.func_174877_v(), 0);
        }
    }

    private void playRecord() {
        SoundEvent record;
        IMedia contents = this.getDiskMedia();
        SoundEvent soundEvent = record = contents != null ? contents.getAudio(this.diskStack) : null;
        if (record != null) {
            RecordUtil.playRecord(record, contents.getAudioTitle(this.diskStack), this.func_145831_w(), this.func_174877_v());
        } else {
            RecordUtil.playRecord(null, null, this.func_145831_w(), this.func_174877_v());
        }
    }

    private void stopRecord() {
        RecordUtil.playRecord(null, null, this.func_145831_w(), this.func_174877_v());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandlerCap == null) {
                this.itemHandlerCap = LazyOptional.of(() -> new InvWrapper((IInventory)this));
            }
            return this.itemHandlerCap.cast();
        }
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> new DiskDrivePeripheral(this));
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }

    @Nonnull
    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new ContainerDiskDrive(id, inventory, this);
    }

    private static class MountInfo {
        String mountPath;

        private MountInfo() {
        }
    }
}

