/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.upload;

import dan200.computercraft.ComputerCraft;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileUpload {
    public static final int CHECKSUM_LENGTH = 32;
    private final String name;
    private final int length;
    private final ByteBuffer bytes;
    private final byte[] checksum;

    public FileUpload(String name, ByteBuffer bytes, byte[] checksum) {
        this.name = name;
        this.bytes = bytes;
        this.length = bytes.remaining();
        this.checksum = checksum;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    @Nonnull
    public byte[] getChecksum() {
        return this.checksum;
    }

    public boolean checksumMatches() {
        byte[] digest = FileUpload.getDigest(this.bytes);
        return digest != null && Arrays.equals(this.checksum, digest);
    }

    @Nullable
    public static byte[] getDigest(ByteBuffer bytes) {
        try {
            bytes.rewind();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bytes);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            ComputerCraft.log.warn("Failed to compute digest ({})", (Object)e.toString());
            return null;
        }
    }
}

