/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.core.asm.DeclaringClassLoader;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.asm.NamedMethod;
import dan200.computercraft.core.asm.Reflect;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public final class Generator<T> {
    private static final AtomicInteger METHOD_ID = new AtomicInteger();
    private static final String METHOD_NAME = "apply";
    private static final String[] EXCEPTIONS = new String[]{org.objectweb.asm.Type.getInternalName(LuaException.class)};
    private static final String INTERNAL_METHOD_RESULT = org.objectweb.asm.Type.getInternalName(MethodResult.class);
    private static final String DESC_METHOD_RESULT = org.objectweb.asm.Type.getDescriptor(MethodResult.class);
    private static final String INTERNAL_ARGUMENTS = org.objectweb.asm.Type.getInternalName(IArguments.class);
    private static final String DESC_ARGUMENTS = org.objectweb.asm.Type.getDescriptor(IArguments.class);
    private final Class<T> base;
    private final List<Class<?>> context;
    private final String[] interfaces;
    private final String methodDesc;
    private final java.util.function.Function<T, T> wrap;
    private final LoadingCache<Class<?>, List<NamedMethod<T>>> classCache = CacheBuilder.newBuilder().build(CacheLoader.from(Generator.catching(this::build, Collections.emptyList())));
    private final LoadingCache<Method, Optional<T>> methodCache = CacheBuilder.newBuilder().build(CacheLoader.from(Generator.catching(this::build, Optional.empty())));

    Generator(Class<T> base, List<Class<?>> context, java.util.function.Function<T, T> wrap) {
        this.base = base;
        this.context = context;
        this.interfaces = new String[]{org.objectweb.asm.Type.getInternalName(base)};
        this.wrap = wrap;
        StringBuilder methodDesc = new StringBuilder().append("(Ljava/lang/Object;");
        for (Class<?> klass : context) {
            methodDesc.append(org.objectweb.asm.Type.getDescriptor(klass));
        }
        methodDesc.append(DESC_ARGUMENTS).append(")").append(DESC_METHOD_RESULT);
        this.methodDesc = methodDesc.toString();
    }

    @Nonnull
    public List<NamedMethod<T>> getMethods(@Nonnull Class<?> klass) {
        try {
            return (List)this.classCache.get(klass);
        }
        catch (ExecutionException e) {
            ComputerCraft.log.error("Error getting methods for {}.", (Object)klass.getName(), (Object)e.getCause());
            return Collections.emptyList();
        }
    }

    @Nonnull
    private List<NamedMethod<T>> build(Class<?> klass) {
        ArrayList<NamedMethod<T>> methods = null;
        for (Method method : klass.getMethods()) {
            LuaFunction annotation = method.getAnnotation(LuaFunction.class);
            if (annotation == null) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                ComputerCraft.log.warn("LuaFunction method {}.{} should be an instance method.", method.getDeclaringClass(), (Object)method.getName());
                continue;
            }
            T instance = ((Optional)this.methodCache.getUnchecked((Object)method)).orElse(null);
            if (instance == null) continue;
            if (methods == null) {
                methods = new ArrayList<NamedMethod<T>>();
            }
            this.addMethod(methods, method, annotation, null, instance);
        }
        for (GenericMethod method : GenericMethod.all()) {
            T instance;
            if (!method.target.isAssignableFrom(klass) || (instance = ((Optional)this.methodCache.getUnchecked((Object)method.method)).orElse(null)) == null) continue;
            if (methods == null) {
                methods = new ArrayList();
            }
            this.addMethod(methods, method.method, method.annotation, method.peripheralType, instance);
        }
        if (methods == null) {
            return Collections.emptyList();
        }
        methods.trimToSize();
        return Collections.unmodifiableList(methods);
    }

    private void addMethod(List<NamedMethod<T>> methods, Method method, LuaFunction annotation, PeripheralType genericType, T instance) {
        boolean isSimple;
        if (annotation.mainThread()) {
            instance = this.wrap.apply(instance);
        }
        String[] names = annotation.value();
        boolean bl = isSimple = method.getReturnType() != MethodResult.class && !annotation.mainThread();
        if (names.length == 0) {
            methods.add(new NamedMethod<T>(method.getName(), instance, isSimple, genericType));
        } else {
            for (String name : names) {
                methods.add(new NamedMethod<T>(name, instance, isSimple, genericType));
            }
        }
    }

    @Nonnull
    private Optional<T> build(Method method) {
        Class<?>[] exceptions;
        String name = method.getDeclaringClass().getName() + "." + method.getName();
        int modifiers = method.getModifiers();
        if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
            ComputerCraft.log.warn("Lua Method {} should be final.", (Object)name);
        }
        if (!Modifier.isPublic(modifiers)) {
            ComputerCraft.log.error("Lua Method {} should be a public method.", (Object)name);
            return Optional.empty();
        }
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            ComputerCraft.log.error("Lua Method {} should be on a public class.", (Object)name);
            return Optional.empty();
        }
        ComputerCraft.log.debug("Generating method wrapper for {}.", (Object)name);
        for (Class<?> exception : exceptions = method.getExceptionTypes()) {
            if (exception == LuaException.class) continue;
            ComputerCraft.log.error("Lua Method {} cannot throw {}.", (Object)name, (Object)exception.getName());
            return Optional.empty();
        }
        Class<?> target = Modifier.isStatic(modifiers) ? method.getParameterTypes()[0] : method.getDeclaringClass();
        try {
            String className = method.getDeclaringClass().getName() + "$cc$" + method.getName() + METHOD_ID.getAndIncrement();
            byte[] bytes = this.generate(className, target, method);
            if (bytes == null) {
                return Optional.empty();
            }
            Class<?> klass = DeclaringClassLoader.INSTANCE.define(className, bytes, method.getDeclaringClass().getProtectionDomain());
            return Optional.of(klass.asSubclass(this.base).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassFormatError | ReflectiveOperationException | RuntimeException e) {
            ComputerCraft.log.error("Error generating wrapper for {}.", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    @Nullable
    private byte[] generate(String className, Class<?> target, Method method) {
        String internalName = className.replace(".", "/");
        ClassWriter cw = new ClassWriter(3);
        cw.visit(52, 17, internalName, null, "java/lang/Object", this.interfaces);
        cw.visitSource("CC generated method", null);
        MethodVisitor mw = cw.visitMethod(1, "<init>", "()V", null, null);
        mw.visitCode();
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mw.visitInsn(177);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
        mw = cw.visitMethod(1, METHOD_NAME, this.methodDesc, null, EXCEPTIONS);
        mw.visitCode();
        if (!Modifier.isStatic(method.getModifiers())) {
            mw.visitVarInsn(25, 1);
            mw.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(target));
        }
        int argIndex = 0;
        for (Type genericArg : method.getGenericParameterTypes()) {
            Boolean loadedArg = this.loadArg(mw, target, method, genericArg, argIndex);
            if (loadedArg == null) {
                return null;
            }
            if (!loadedArg.booleanValue()) continue;
            ++argIndex;
        }
        mw.visitMethodInsn(Modifier.isStatic(method.getModifiers()) ? 184 : 182, org.objectweb.asm.Type.getInternalName(method.getDeclaringClass()), method.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)method), false);
        Class<?> ret = method.getReturnType();
        if (ret != MethodResult.class) {
            if (ret == Void.TYPE) {
                mw.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "of", "()" + DESC_METHOD_RESULT, false);
            } else if (ret.isPrimitive()) {
                Class boxed = Primitives.wrap(ret);
                mw.visitMethodInsn(184, org.objectweb.asm.Type.getInternalName((Class)boxed), "valueOf", "(" + org.objectweb.asm.Type.getDescriptor(ret) + ")" + org.objectweb.asm.Type.getDescriptor((Class)boxed), false);
                mw.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "of", "(Ljava/lang/Object;)" + DESC_METHOD_RESULT, false);
            } else if (ret == Object[].class) {
                mw.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "of", "([Ljava/lang/Object;)" + DESC_METHOD_RESULT, false);
            } else {
                mw.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "of", "(Ljava/lang/Object;)" + DESC_METHOD_RESULT, false);
            }
        }
        mw.visitInsn(176);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private Boolean loadArg(MethodVisitor mw, Class<?> target, Method method, Type genericArg, int argIndex) {
        String name;
        if (genericArg == target) {
            mw.visitVarInsn(25, 1);
            mw.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(target));
            return false;
        }
        Class<?> arg = Reflect.getRawType(method, genericArg, true);
        if (arg == null) {
            return null;
        }
        if (arg == IArguments.class) {
            mw.visitVarInsn(25, 2 + this.context.size());
            return false;
        }
        int idx = this.context.indexOf(arg);
        if (idx >= 0) {
            mw.visitVarInsn(25, 2 + idx);
            return false;
        }
        if (arg == Optional.class) {
            Class<?> klass = Reflect.getRawType(method, TypeToken.of((Type)genericArg).resolveType(Reflect.OPTIONAL_IN).getType(), false);
            if (klass == null) {
                return null;
            }
            if (Enum.class.isAssignableFrom(klass) && klass != Enum.class) {
                mw.visitVarInsn(25, 2 + this.context.size());
                Reflect.loadInt(mw, argIndex);
                mw.visitLdcInsn((Object)org.objectweb.asm.Type.getType(klass));
                mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "optEnum", "(ILjava/lang/Class;)Ljava/util/Optional;", true);
                return true;
            }
            String name2 = Reflect.getLuaName(Primitives.unwrap(klass));
            if (name2 != null) {
                mw.visitVarInsn(25, 2 + this.context.size());
                Reflect.loadInt(mw, argIndex);
                mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "opt" + name2, "(I)Ljava/util/Optional;", true);
                return true;
            }
        }
        if (Enum.class.isAssignableFrom(arg) && arg != Enum.class) {
            mw.visitVarInsn(25, 2 + this.context.size());
            Reflect.loadInt(mw, argIndex);
            mw.visitLdcInsn((Object)org.objectweb.asm.Type.getType(arg));
            mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "getEnum", "(ILjava/lang/Class;)Ljava/lang/Enum;", true);
            mw.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(arg));
            return true;
        }
        String string = name = arg == Object.class ? "" : Reflect.getLuaName(arg);
        if (name != null) {
            if (Reflect.getRawType(method, genericArg, false) == null) {
                return null;
            }
            mw.visitVarInsn(25, 2 + this.context.size());
            Reflect.loadInt(mw, argIndex);
            mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "get" + name, "(I)" + org.objectweb.asm.Type.getDescriptor(arg), true);
            return true;
        }
        ComputerCraft.log.error("Unknown parameter type {} for method {}.{}.", (Object)arg.getName(), (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        return null;
    }

    private static <T, U> Function<T, U> catching(java.util.function.Function<T, U> function, U def) {
        return x -> {
            try {
                return function.apply(x);
            }
            catch (Exception | LinkageError e) {
                ComputerCraft.log.error("Error generating @LuaFunctions", e);
                return def;
            }
        };
    }
}

