/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;

public class SoundManager {
    private static final Map<UUID, MoveableSound> sounds = new HashMap<UUID, MoveableSound>();

    public static void playSound(UUID source, Vector3d position, ResourceLocation event, float volume, float pitch) {
        SoundHandler soundManager = Minecraft.func_71410_x().func_147118_V();
        MoveableSound oldSound = sounds.get(source);
        if (oldSound != null) {
            soundManager.func_147683_b((ISound)oldSound);
        }
        MoveableSound newSound = new MoveableSound(event, position, volume, pitch);
        sounds.put(source, newSound);
        soundManager.func_147682_a((ISound)newSound);
    }

    public static void stopSound(UUID source) {
        ISound sound = (ISound)sounds.remove(source);
        if (sound == null) {
            return;
        }
        Minecraft.func_71410_x().func_147118_V().func_147683_b(sound);
    }

    public static void moveSound(UUID source, Vector3d position) {
        MoveableSound sound = sounds.get(source);
        if (sound != null) {
            sound.setPosition(position);
        }
    }

    public static void reset() {
        sounds.clear();
    }

    private static class MoveableSound
    extends LocatableSound
    implements ITickableSound {
        protected MoveableSound(ResourceLocation sound, Vector3d position, float volume, float pitch) {
            super(sound, SoundCategory.RECORDS);
            this.setPosition(position);
            this.field_147662_b = volume;
            this.field_147663_c = pitch;
            this.field_147666_i = ISound.AttenuationType.LINEAR;
        }

        void setPosition(Vector3d position) {
            this.field_147660_d = (float)position.func_82615_a();
            this.field_147661_e = (float)position.func_82617_b();
            this.field_147658_f = (float)position.func_82616_c();
        }

        public boolean func_147667_k() {
            return false;
        }

        public void func_73660_a() {
        }
    }
}

