/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.world;

import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.function.Function;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class DimensionTransit
implements ITeleporter {
    protected ServerWorld world;
    private BlockPosDim target;

    public DimensionTransit(ServerWorld world, BlockPosDim target) {
        this.world = world;
        this.target = target;
    }

    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        BlockPos myPos = this.moveToSafeCoords(destWorld, this.target.getPos());
        return new PortalInfo(new Vector3d((double)((float)myPos.func_177958_n() + 0.5f), (double)((float)myPos.func_177956_o() + 0.5f), (double)((float)myPos.func_177952_p() + 0.5f)), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
    }

    private BlockPos moveToSafeCoords(ServerWorld world, BlockPos pos) {
        for (int tries = 10; tries > 0; --tries) {
            if (!world.func_180495_p(pos).func_200132_m()) continue;
            pos = pos.func_177984_a();
        }
        return pos;
    }

    public Entity placeEntity(Entity newEntity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (newEntity instanceof LivingEntity) {
            ((LivingEntity)newEntity).func_195064_c(new EffectInstance(Effects.field_76429_m, 200, 200, false, false));
            ((LivingEntity)newEntity).func_195064_c(new EffectInstance(Effects.field_204839_B, 20, 20, false, false));
        }
        newEntity.field_70143_R = 0.0f;
        return repositionEntity.apply(false);
    }

    public void teleport(PlayerEntity player) {
        if (this.world != null && this.world.func_73046_m() != null) {
            this.world.func_184148_a(null, this.target.getX() + 0.5, this.target.getY() + 0.5, this.target.getZ() + 0.5, SoundEvents.field_187812_eh, SoundCategory.MASTER, 0.25f, this.world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
    }

    public ServerWorld getTargetWorld() {
        return this.world.func_73046_m().func_71218_a(UtilWorld.stringToDimension(this.target.getDimension()));
    }
}

