/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.wireless.fluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.wireless.fluid.ContainerWirelessFluid;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilWorld;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWirelessFluid
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    public static final int CAPACITY = 64000;
    static final int MAX = 64000;
    public static final int MAX_TRANSFER = 64000;
    private int transferRate = 1000;
    public FluidTankBase tank;
    ItemStackHandler gpsSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() instanceof LocationGpsCard;
        }
    };

    public TileWirelessFluid() {
        super((TileEntityType)TileRegistry.WIRELESS_FLUID.get());
        this.needsRedstone = 0;
        this.tank = new FluidTankBase(this, 64000, f -> true);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerWirelessFluid(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.gpsSlots.deserializeNBT(tag.func_74775_l("inv"));
        this.transferRate = tag.func_74762_e("transferRate");
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("transferRate", this.transferRate);
        tag.func_218657_a("inv", (INBT)this.gpsSlots.serializeNBT());
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        return super.func_189515_b(tag);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean moved = false;
        BlockPosDim loc = this.getTargetInSlot(0);
        if (loc != null && UtilWorld.dimensionIsEqual(loc, this.field_145850_b)) {
            this.moveFluids(loc.getSide(), loc.getPos(), this.transferRate, (IFluidHandler)this.tank);
        }
        this.setLitProperty(moved);
    }

    BlockPosDim getTargetInSlot(int s) {
        return LocationGpsCard.getPosition(this.gpsSlots.getStackInSlot(s));
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                this.transferRate = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
        }
        return 0;
    }

    public float getRed() {
        return 0.89f;
    }

    public float getBlue() {
        return 0.0f;
    }

    public float getGreen() {
        return 0.12f;
    }

    public float getAlpha() {
        return 0.9f;
    }

    public float getThick() {
        return 0.065f;
    }

    static enum Fields {
        RENDER,
        TRANSFER_RATE,
        REDSTONE;

    }
}

