/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.shapebuilder;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.shapebuilder.BuildStructureType;
import com.lothrazar.cyclic.block.shapebuilder.ContainerStructure;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.RelativeShape;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileStructure
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    public static ForgeConfigSpec.IntValue POWERCONF;
    static final int SLOT_BUILD = 0;
    protected static final int SLOT_SHAPE = 1;
    protected static final int SLOT_GPS = 2;
    public static final int MAXHEIGHT = 100;
    static final int MAX = 64000;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(3){

        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.stacks.size()) {
                return ItemStack.field_190927_a;
            }
            return super.getStackInSlot(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return Block.func_149634_a((Item)stack.func_77973_b()) != null;
            }
            if (slot == 1) {
                return stack.func_77973_b() instanceof ShapeCard;
            }
            return stack.func_77973_b() instanceof LocationGpsCard;
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private BuildStructureType buildType = BuildStructureType.FACING;
    private int buildSize = 3;
    private int height = 2;
    private int shapeIndex = 0;
    private static final int spotsSkippablePerTrigger = 50;

    public TileStructure() {
        super(TileRegistry.STRUCTURE);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        int t = tag.func_74762_e("buildType");
        this.buildType = BuildStructureType.values()[t];
        this.buildSize = tag.func_74762_e("buildSize");
        this.height = tag.func_74762_e("height");
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("buildType", this.buildType.ordinal());
        tag.func_74768_a("buildSize", this.buildSize);
        tag.func_74768_a("height", this.height);
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerStructure(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case BUILDTYPE: {
                if (value >= BuildStructureType.values().length) {
                    value = 0;
                }
                this.buildType = BuildStructureType.values()[value];
                break;
            }
            case SIZE: {
                this.buildSize = value;
                break;
            }
            case HEIGHT: {
                if (value > 100) {
                    value = 100;
                }
                this.height = Math.max(1, value);
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case TIMER: {
                return this.timer;
            }
            case BUILDTYPE: {
                return this.buildType.ordinal();
            }
            case SIZE: {
                return this.buildSize;
            }
            case HEIGHT: {
                return this.height;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return;
        }
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        BlockPos nextPos = shape.get(this.shapeIndex);
        ItemStack stack = this.inventory.getStackInSlot(0);
        Block stuff = Block.func_149634_a((Item)stack.func_77973_b());
        if (stuff == null) {
            return;
        }
        int cost = (Integer)POWERCONF.get();
        for (int i = 0; i < 50 && (this.energy.getEnergyStored() >= cost || cost <= 0); ++i) {
            if (!World.func_189509_E((BlockPos)nextPos) && this.field_145850_b.func_175623_d(nextPos)) {
                BlockState placeState = stuff.func_176223_P();
                if (this.field_145850_b.field_72995_K || !UtilPlaceBlocks.placeStateSafe(this.field_145850_b, null, nextPos, placeState)) break;
                this.incrementPosition(shape);
                stack.func_190918_g(1);
                this.energy.extractEnergy(cost, false);
                break;
            }
            nextPos = shape.get(this.shapeIndex);
            this.incrementPosition(shape);
        }
    }

    private void incrementPosition(List<BlockPos> shape) {
        if (shape == null || shape.size() == 0) {
            return;
        }
        int c = this.shapeIndex + 1;
        if (c < 0 || c >= shape.size()) {
            c = 0;
        }
        this.shapeIndex = c;
    }

    private BlockPos getPosTarget() {
        BlockPosDim loc;
        if (2 < this.inventory.getSlots() && (loc = LocationGpsCard.getPosition(this.inventory.getStackInSlot(2))) != null && loc.getPos() != null) {
            return loc.getPos();
        }
        return this.func_174877_v();
    }

    public BlockPos getTargetFacing() {
        return this.getPosTarget().func_177967_a(this.getCurrentFacing(), this.buildSize + 1);
    }

    public List<BlockPos> getShape() {
        RelativeShape shape;
        ItemStack shapeCard;
        if (1 < this.inventory.getSlots() && (shapeCard = this.inventory.getStackInSlot(1)).func_77973_b() instanceof ShapeCard && (shape = RelativeShape.read(shapeCard)) != null) {
            shape.setWorldCenter(this.field_145850_b, this.getPosTarget());
            if (shape.getShape() != null && shape.getShape().size() > 0) {
                return shape.getShape();
            }
        }
        List<BlockPos> shape2 = new ArrayList<BlockPos>();
        switch (this.buildType) {
            case CIRCLE: {
                shape2 = UtilShape.circleHorizontal(this.getPosTarget(), this.getSize() * 2);
                shape2 = UtilShape.repeatShapeByHeight(shape2, this.getHeight() - 1);
                break;
            }
            case FACING: {
                shape2 = UtilShape.line(this.getPosTarget(), this.getCurrentFacing(), this.getSize());
                shape2 = UtilShape.repeatShapeByHeight(shape2, this.getHeight() - 1);
                break;
            }
            case SQUARE: {
                shape2 = UtilShape.squareHorizontalHollow(this.getPosTarget(), this.getSize());
                shape2 = UtilShape.repeatShapeByHeight(shape2, this.getHeight() - 1);
                break;
            }
            case SOLID: {
                shape2 = UtilShape.squareHorizontalFull(this.getTargetFacing(), this.getSize());
                shape2 = UtilShape.repeatShapeByHeight(shape2, this.getHeight() - 1);
                break;
            }
            case SPHERE: {
                shape2 = UtilShape.sphere(this.getPosTarget(), this.getSize());
                break;
            }
            case DOME: {
                shape2 = UtilShape.sphereDome(this.getPosTarget(), this.getSize());
                break;
            }
            case CUP: {
                shape2 = UtilShape.sphereCup(this.getPosTarget().func_177981_b(this.getSize()), this.getSize());
                break;
            }
            case DIAGONAL: {
                shape2 = UtilShape.diagonal(this.getPosTarget(), this.getCurrentFacing(), this.getSize() * 2, true);
                break;
            }
            case PYRAMID: {
                shape2 = UtilShape.squarePyramid(this.getPosTarget(), this.getSize(), this.getHeight());
            }
        }
        return shape2;
    }

    private int getHeight() {
        return this.height;
    }

    private int getSize() {
        return this.buildSize;
    }

    static enum Fields {
        TIMER,
        BUILDTYPE,
        SIZE,
        HEIGHT,
        REDSTONE,
        RENDER;

    }
}

