/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderctrl;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.enderctrl.EnderControllerItemHandler;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEnderCtrl
extends TileEntityBase {
    private static final String NBT_SHELVES = "shelves";
    EnderControllerItemHandler controllerInv = new EnderControllerItemHandler(this);
    private final LazyOptional<EnderControllerItemHandler> controllerInventoryCap = LazyOptional.of(() -> this.controllerInv);
    private List<BlockPos> connectedShelves = new ArrayList<BlockPos>();
    TileEnderShelf.RenderTextType renderStyle = TileEnderShelf.RenderTextType.TEXT;

    public TileEnderCtrl() {
        super(TileRegistry.ender_controller);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public void setShelves(Set<BlockPos> shelvesIn) {
        ModCyclic.LOGGER.info("resetting and sorting the shelves " + shelvesIn.size());
        this.connectedShelves = shelvesIn.stream().sorted(Comparator.comparing(o -> o.func_177951_i((Vector3i)this.field_174879_c))).collect(Collectors.toList());
    }

    public List<BlockPos> getShelves() {
        if (this.connectedShelves == null) {
            this.connectedShelves = new ArrayList<BlockPos>();
        }
        return this.connectedShelves;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.controllerInventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        if (tag.func_74764_b("RenderTextType")) {
            int rt = tag.func_74762_e("RenderTextType");
            this.renderStyle = TileEnderShelf.RenderTextType.values()[rt];
        }
        if (tag.func_74764_b(NBT_SHELVES)) {
            ListNBT shelves = tag.func_150295_c(NBT_SHELVES, 10);
            for (int i = 0; i < shelves.size(); ++i) {
                BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)shelves.func_150305_b(i));
                this.connectedShelves.add(pos);
            }
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("RenderTextType", this.renderStyle.ordinal());
        ListNBT shelves = new ListNBT();
        for (BlockPos pos : this.connectedShelves) {
            shelves.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
        }
        tag.func_218657_a(NBT_SHELVES, (INBT)shelves);
        return super.func_189515_b(tag);
    }

    public void toggleShowText() {
        int ord = this.renderStyle.ordinal() + 1;
        if (ord == TileEnderShelf.RenderTextType.values().length) {
            ord = 0;
        }
        this.renderStyle = TileEnderShelf.RenderTextType.values()[ord];
    }
}

