/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderctrl;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.enderctrl.EnderShelfHelper;
import com.lothrazar.cyclic.block.enderctrl.TileEnderCtrl;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.util.UtilEnchant;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.ItemStackHandler;

public class EnderControllerItemHandler
extends ItemStackHandler {
    static final int SLOTS_PER_SHELF = 5;
    private final TileEnderCtrl controller;

    public EnderControllerItemHandler(TileEnderCtrl controller) {
        super(1);
        this.controller = controller;
    }

    public ItemStack insertItem(int slot, ItemStack remaining, boolean simulate) {
        if (remaining.func_77973_b() != Items.field_151134_bR) {
            return remaining;
        }
        if (!(remaining = this.insertItemElsewhere(remaining, false, simulate)).func_190926_b()) {
            remaining = this.insertItemElsewhere(remaining, true, simulate);
        }
        return remaining;
    }

    private ItemStack insertItemElsewhere(ItemStack stack, boolean insertWhenEmpty, boolean simulate) {
        if (this.controller.func_145831_w() == null) {
            return stack;
        }
        for (BlockPos shelfPos : this.controller.getShelves()) {
            TileEntity te = this.controller.func_145831_w().func_175625_s(shelfPos);
            if (te == null || !EnderShelfHelper.isShelf(te.func_195044_w())) continue;
            TileEnderShelf shelf = (TileEnderShelf)te;
            try {
                stack = this.insertItemActual(shelf, stack, insertWhenEmpty, simulate);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Insert item shelf error", e);
            }
        }
        return stack;
    }

    private ItemStack insertItemActual(TileEnderShelf shelf, ItemStack stack, boolean insertWhenEmpty, boolean simulate) {
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        int slots = shelf.inventory.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = shelf.inventory.getStackInSlot(i);
            if (slotStack.func_190926_b()) {
                emptySlots.add(i);
                continue;
            }
            if (slotStack.func_190916_E() >= shelf.inventory.getStackLimit(i, stack) || !UtilEnchant.doBookEnchantmentsMatch(stack, slotStack)) continue;
            return shelf.inventory.insertItem(i, stack, simulate);
        }
        if (emptySlots.size() > 0 && insertWhenEmpty) {
            return shelf.inventory.insertItem((Integer)emptySlots.get(0), stack, simulate);
        }
        return stack;
    }

    public int getSlots() {
        return this.controller.getShelves().size() * 5;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.insertItem(slot, stack, false);
        this.onContentsChanged(slot);
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.controller.getShelves().size() == 0 || this.controller.func_145831_w() == null) {
            return ItemStack.field_190927_a;
        }
        int shelf = slot / 5;
        int realSlot = slot % 5;
        EnderShelfItemHandler handler = this.getHandlerAt(shelf);
        if (handler != null) {
            return handler.getStackInSlot(realSlot);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItemElsewhere(slot, amount, simulate);
    }

    private ItemStack extractItemElsewhere(int slot, int amount, boolean simulate) {
        if (this.controller.getShelves().size() == 0 || this.controller.func_145831_w() == null) {
            return ItemStack.field_190927_a;
        }
        int shelf = slot / 5;
        int realSlot = slot % 5;
        EnderShelfItemHandler handler = this.getHandlerAt(shelf);
        if (handler != null) {
            return handler.extractItem(realSlot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    private EnderShelfItemHandler getHandlerAt(int shelf) {
        try {
            BlockPos extractPos = this.controller.getShelves().get(shelf);
            TileEntity te = this.controller.func_145831_w().func_175625_s(extractPos);
            return EnderShelfHelper.getShelfHandler(te);
        }
        catch (Exception e) {
            return null;
        }
    }
}

