/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.shynieke.statues.recipe.StatuesRecipes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HardcoreRecipe
extends ShapedRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;

    public HardcoreRecipe(ResourceLocation location, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(location, group, width, height, recipeItems, result);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)StatuesRecipes.HARDCORE_SHAPED_SERIALIZER.get();
    }

    public boolean func_77569_a(CraftingInventory inventory, World world) {
        return super.func_77569_a(inventory, world) && world.func_72912_H().func_76093_s();
    }

    public ItemStack func_77571_b() {
        ItemStack resultStack = super.func_77571_b();
        CompoundNBT display = resultStack.func_190925_c("display");
        if (!display.func_74764_b("lore")) {
            ListNBT nbtTagList = new ListNBT();
            nbtTagList.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent("Only craftable in Hardcore Mode").func_240699_a_(TextFormatting.DARK_PURPLE))));
            display.func_218657_a("Lore", (INBT)nbtTagList);
        }
        return resultStack;
    }

    public ItemStack func_77572_b(CraftingInventory container) {
        return this.func_77571_b().func_77946_l();
    }

    private static NonNullList<Ingredient> dissolvePattern(String[] p_192402_0_, Map<String, Ingredient> p_192402_1_, int p_192402_2_, int p_192402_3_) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(p_192402_2_ * p_192402_3_), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(p_192402_1_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_192402_0_.length; ++i) {
            for (int j = 0; j < p_192402_0_[i].length(); ++j) {
                String s = p_192402_0_[i].substring(j, j + 1);
                Ingredient ingredient = p_192402_1_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_192402_2_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    private static Map<String, Ingredient> keyFromJson(JsonObject jsonObject) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    @VisibleForTesting
    static String[] shrink(String ... p_194134_0_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_194134_0_.length; ++i1) {
            String s = p_194134_0_[i1];
            i = Math.min(i, HardcoreRecipe.firstNonSpace(s));
            int j1 = HardcoreRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_194134_0_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_194134_0_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_194134_0_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String p_194135_0_) {
        int i;
        for (i = 0; i < p_194135_0_.length() && p_194135_0_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String p_194136_0_) {
        int i;
        for (i = p_194136_0_.length() - 1; i >= 0 && p_194136_0_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray p_192407_0_) {
        String[] astring = new String[p_192407_0_.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)p_192407_0_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<HardcoreRecipe> {
        public HardcoreRecipe fromJson(ResourceLocation location, JsonObject jsonObject) {
            String s = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"group", (String)"");
            Map map = HardcoreRecipe.keyFromJson(JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"key"));
            String[] pattern = HardcoreRecipe.shrink(HardcoreRecipe.patternFromJson(JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"pattern")));
            int i = pattern[0].length();
            int j = pattern.length;
            NonNullList nonnulllist = HardcoreRecipe.dissolvePattern(pattern, map, i, j);
            ItemStack itemstack = HardcoreRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"result"));
            return new HardcoreRecipe(location, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public HardcoreRecipe fromNetwork(ResourceLocation location, PacketBuffer byteBuf) {
            int i = byteBuf.func_150792_a();
            int j = byteBuf.func_150792_a();
            String s = byteBuf.func_218666_n();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)byteBuf));
            }
            ItemStack itemstack = byteBuf.func_150791_c();
            return new HardcoreRecipe(location, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(PacketBuffer byteBuf, HardcoreRecipe recipe) {
            byteBuf.func_150787_b(recipe.func_192403_f());
            byteBuf.func_150787_b(recipe.func_192404_g());
            byteBuf.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(byteBuf);
            }
            byteBuf.func_150788_a(recipe.func_77571_b());
        }
    }
}

