/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.init.StatueRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FishHandler {
    @SubscribeEvent
    public void onItemFished(ItemFishedEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            ItemStack itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.EAGLE_RAY.get());
            this.dropFishedStatue(itemStackToDrop, (Entity)player, event);
        }
    }

    public void dropFishedStatue(ItemStack itemStackToDrop, Entity source, ItemFishedEvent event) {
        double random_drop = Math.random();
        double default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayerEntity) || source instanceof FakePlayer) break;
                ServerPlayerEntity player = (ServerPlayerEntity)source;
                List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                if (!luckyPlayers.isEmpty()) {
                    for (String luckyName : luckyPlayers) {
                        String user = player.func_200200_C_().func_150261_e();
                        if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                        default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get() / 4.0;
                    }
                }
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add((Object)itemStackToDrop);
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayerEntity) || !(random_drop <= default_drop_chance)) break;
                event.getDrops().add((Object)itemStackToDrop);
                break;
            }
            case ALL: {
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add((Object)itemStackToDrop);
            }
        }
    }
}

