/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.shynieke.statues.Statues;
import com.shynieke.statues.client.screen.DecimalNumberFieldWidget;
import com.shynieke.statues.client.screen.NumberFieldWidget;
import com.shynieke.statues.client.screen.PlayerStatueData;
import com.shynieke.statues.client.screen.ToggleButton;
import com.shynieke.statues.entity.PlayerStatueEntity;
import com.shynieke.statues.packets.PlayerStatueSyncMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class PlayerPoseScreen
extends Screen {
    private final PlayerStatueEntity playerStatueEntity;
    private final PlayerStatueData playerStatueData;
    private final String[] buttonLabels = new String[]{"small", "rotation", "y_offset", "locked", "name_visible", "gravity"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm"};
    private NumberFieldWidget rotationTextField;
    private DecimalNumberFieldWidget YOffsetTextField;
    private ToggleButton smallButton;
    private ToggleButton lockButton;
    private ToggleButton nameVisibleButton;
    private ToggleButton noGravityButton;
    private final NumberFieldWidget[] poseTextFields = new NumberFieldWidget[18];
    private Button doneButton;
    private Button cancelButton;

    public PlayerPoseScreen(PlayerStatueEntity playerStatue) {
        super(NarratorChatListener.field_216868_a);
        int i;
        this.playerStatueEntity = playerStatue;
        this.playerStatueData = new PlayerStatueData();
        this.playerStatueData.readNBT(this.playerStatueEntity.func_189511_e(new CompoundNBT()));
        for (i = 0; i < this.buttonLabels.length; ++i) {
            this.buttonLabels[i] = I18n.func_135052_a((String)String.format("%s.playerstatue.gui.label." + this.buttonLabels[i], "statues"), (Object[])new Object[0]);
        }
        for (i = 0; i < this.sliderLabels.length; ++i) {
            this.sliderLabels[i] = I18n.func_135052_a((String)String.format("%s.playerstatue.gui.label." + this.sliderLabels[i], "statues"), (Object[])new Object[0]);
        }
    }

    public static void openScreen(PlayerStatueEntity playerStatue) {
        Minecraft.func_71410_x().func_147108_a((Screen)new PlayerPoseScreen(playerStatue));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int offsetX = 110;
        int offsetY = 50;
        this.smallButton = new ToggleButton(offsetX, offsetY, 40, 20, this.playerStatueData.isSmall(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        });
        this.func_230480_a_((Widget)this.smallButton);
        this.lockButton = new ToggleButton(offsetX, offsetY + 66, 40, 20, this.playerStatueData.isLocked(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        });
        this.func_230480_a_((Widget)this.lockButton);
        this.nameVisibleButton = new ToggleButton(offsetX, offsetY + 89, 40, 20, this.playerStatueData.getNameVisible(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        });
        this.func_230480_a_((Widget)this.nameVisibleButton);
        this.noGravityButton = new ToggleButton(offsetX, offsetY + 112, 40, 20, this.playerStatueData.hasNoGravity(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        });
        this.func_230480_a_((Widget)this.noGravityButton);
        this.rotationTextField = new NumberFieldWidget(this.field_230712_o_, 1 + offsetX, 1 + offsetY + 22, 38, 17, (ITextComponent)new StringTextComponent("field.rotation"));
        this.rotationTextField.func_146180_a(String.valueOf((int)this.playerStatueData.rotation));
        this.rotationTextField.func_146203_f(3);
        this.func_230481_d_((IGuiEventListener)this.rotationTextField);
        this.YOffsetTextField = new DecimalNumberFieldWidget(this.field_230712_o_, 1 + offsetX, 1 + offsetY + 44, 38, 17, (ITextComponent)new StringTextComponent("field.yOffset"));
        this.YOffsetTextField.func_146180_a(String.valueOf(MathHelper.func_76131_a((float)this.playerStatueData.yOffset, (float)-1.0f, (float)1.0f)));
        this.YOffsetTextField.func_146203_f(5);
        this.func_230481_d_((IGuiEventListener)this.YOffsetTextField);
        offsetX = this.field_230708_k_ - 20 - 100;
        for (int i = 0; i < this.poseTextFields.length; ++i) {
            int x = 1 + offsetX + i % 3 * 35;
            int y = 1 + offsetY + i / 3 * 22;
            int width = 28;
            int height = 17;
            String value = String.valueOf((int)this.playerStatueData.pose[i]);
            this.poseTextFields[i] = new NumberFieldWidget(this.field_230712_o_, x, y, width, height, (ITextComponent)new StringTextComponent(String.format("field.%s", i)));
            this.poseTextFields[i].func_146180_a(value);
            this.poseTextFields[i].func_146203_f(3);
            this.func_230481_d_((IGuiEventListener)this.poseTextFields[i]);
        }
        offsetY = this.field_230709_l_ / 4 + 120 + 12;
        offsetX = this.field_230708_k_ - 20;
        this.doneButton = new Button(offsetX - 194, offsetY, 96, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> {
            this.updateEntity(this.writeFieldsToNBT());
            this.field_230706_i_.func_147108_a((Screen)null);
        });
        this.func_230480_a_((Widget)this.doneButton);
        this.cancelButton = new Button(offsetX - 96, offsetY, 96, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> {
            this.updateEntity(this.playerStatueData.writeNBT());
            this.field_230706_i_.func_147108_a((Screen)null);
        });
        this.func_230480_a_((Widget)this.cancelButton);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int y;
        int i;
        this.func_230446_a_(matrixStack);
        PlayerPoseScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)String.format("%s.playerstatue.gui.title", "statues"), (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        this.rotationTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.YOffsetTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (NumberFieldWidget textField : this.poseTextFields) {
            textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        int offsetY = 50;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            this.field_230712_o_.getClass();
            y = offsetY + i * 22 + (10 - 9 / 2);
            PlayerPoseScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.buttonLabels[i], (int)x, (int)y, (int)0xA0A0A0);
        }
        offsetX = this.field_230708_k_ - 20 - 100;
        PlayerPoseScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"X", (int)offsetX, (int)37, (int)0xA0A0A0);
        PlayerPoseScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Y", (int)(offsetX + 35), (int)37, (int)0xA0A0A0);
        PlayerPoseScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Z", (int)(offsetX + 70), (int)37, (int)0xA0A0A0);
        for (i = 0; i < this.sliderLabels.length; ++i) {
            int x = offsetX - this.field_230712_o_.func_78256_a(this.sliderLabels[i]) - 10;
            this.field_230712_o_.getClass();
            y = offsetY + i * 22 + (10 - 9 / 2);
            PlayerPoseScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.sliderLabels[i], (int)x, (int)y, (int)0xA0A0A0);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.rotationTextField.func_146178_a();
        this.YOffsetTextField.func_146178_a();
        for (NumberFieldWidget textField : this.poseTextFields) {
            textField.func_146178_a();
        }
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        boolean typed = super.func_231042_a_(codePoint, modifiers);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].func_230999_j_()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].func_146202_e();
                this.poseTextFields[i].func_230996_d_(false);
                int j = !Screen.func_231173_s_() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].func_230996_d_(true);
                this.poseTextFields[j].func_146190_e(0);
                this.poseTextFields[j].func_146199_i(this.poseTextFields[j].func_146179_b().length());
            }
        } else {
            if (this.rotationTextField.func_231046_a_(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.YOffsetTextField.func_231046_a_(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldWidget textField : this.poseTextFields) {
                if (!textField.func_231046_a_(keyCode, scanCode, modifiers)) continue;
                this.textFieldUpdated();
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.rotationTextField.func_231044_a_(mouseX, mouseY, button);
        this.YOffsetTextField.func_231044_a_(mouseX, mouseY, button);
        for (NumberFieldWidget textField : this.poseTextFields) {
            textField.func_231044_a_(mouseX, mouseY, button);
            this.textFieldUpdated();
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.writeFieldsToNBT());
    }

    private CompoundNBT writeFieldsToNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74757_a("Small", this.smallButton.getValue());
        compound.func_74757_a("Locked", this.lockButton.getValue());
        compound.func_74757_a("CustomNameVisible", this.nameVisibleButton.getValue());
        compound.func_74757_a("NoGravity", this.noGravityButton.getValue());
        compound.func_74780_a("yOffset", (double)this.YOffsetTextField.getFloat());
        ListNBT rotationTag = new ListNBT();
        rotationTag.add((Object)FloatNBT.func_229689_a_((float)this.rotationTextField.getFloat()));
        compound.func_218657_a("Rotation", (INBT)rotationTag);
        CompoundNBT poseTag = new CompoundNBT();
        ListNBT poseHeadTag = new ListNBT();
        poseHeadTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[0].getFloat()));
        poseHeadTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[1].getFloat()));
        poseHeadTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[2].getFloat()));
        poseTag.func_218657_a("Head", (INBT)poseHeadTag);
        ListNBT poseBodyTag = new ListNBT();
        poseBodyTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[3].getFloat()));
        poseBodyTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[4].getFloat()));
        poseBodyTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[5].getFloat()));
        poseTag.func_218657_a("Body", (INBT)poseBodyTag);
        ListNBT poseLeftLegTag = new ListNBT();
        poseLeftLegTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[6].getFloat()));
        poseLeftLegTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[7].getFloat()));
        poseLeftLegTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[8].getFloat()));
        poseTag.func_218657_a("LeftLeg", (INBT)poseLeftLegTag);
        ListNBT poseRightLegTag = new ListNBT();
        poseRightLegTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[9].getFloat()));
        poseRightLegTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[10].getFloat()));
        poseRightLegTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[11].getFloat()));
        poseTag.func_218657_a("RightLeg", (INBT)poseRightLegTag);
        ListNBT poseLeftArmTag = new ListNBT();
        poseLeftArmTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[12].getFloat()));
        poseLeftArmTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[13].getFloat()));
        poseLeftArmTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[14].getFloat()));
        poseTag.func_218657_a("LeftArm", (INBT)poseLeftArmTag);
        ListNBT poseRightArmTag = new ListNBT();
        poseRightArmTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[15].getFloat()));
        poseRightArmTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[16].getFloat()));
        poseRightArmTag.add((Object)FloatNBT.func_229689_a_((float)this.poseTextFields[17].getFloat()));
        poseTag.func_218657_a("RightArm", (INBT)poseRightArmTag);
        compound.func_218657_a("Pose", (INBT)poseTag);
        return compound;
    }

    private void updateEntity(CompoundNBT compound) {
        CompoundNBT CompoundNBT2 = this.playerStatueEntity.func_189511_e(new CompoundNBT()).func_74737_b();
        CompoundNBT2.func_197643_a(compound);
        this.playerStatueEntity.func_70020_e(CompoundNBT2);
        Statues.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PlayerStatueSyncMessage(this.playerStatueEntity.func_110124_au(), compound));
    }

    public boolean func_231177_au__() {
        return false;
    }
}

