/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.client.StatuePlayerModel;
import com.shynieke.statues.tiles.PlayerTile;
import com.shynieke.statues.util.SkinUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class PlayerTileRenderer
extends TileEntityRenderer<PlayerTile> {
    public static final StatuePlayerModel model = new StatuePlayerModel(0.03125f, false);
    public static final StatuePlayerModel slimModel = new StatuePlayerModel(0.03125f, true);
    public static final ResourceLocation defaultTexture = DefaultPlayerSkin.func_177335_a();
    private static final Map<String, GameProfile> GAMEPROFILE_CACHE = new HashMap<String, GameProfile>();

    public PlayerTileRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(PlayerTile te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate = te.func_195044_w();
        boolean flag = blockstate.func_177230_c() instanceof PlayerStatueBlock;
        Direction direction = flag ? (Direction)blockstate.func_177229_b((Property)PlayerStatueBlock.field_185512_D) : Direction.UP;
        GameProfile profile = te.getPlayerProfile();
        PlayerTileRenderer.render(direction, profile, te.isSlim(), matrixStackIn, bufferIn, combinedLightIn);
    }

    public static void render(@Nullable Direction direction, @Nullable GameProfile profile, boolean isSlim, MatrixStack matrix, IRenderTypeBuffer typeBuffer, int combinedLight) {
        StatuePlayerModel playerModel = model;
        matrix.func_227861_a_(0.5, 0.25, 0.5);
        matrix.func_227860_a_();
        if (direction != null) {
            switch (direction) {
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    break;
                }
                case WEST: {
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                    break;
                }
                default: {
                    matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                }
            }
        }
        matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrix.func_227861_a_(0.0, -1.25, 0.0);
        if (isSlim) {
            playerModel = slimModel;
        }
        IVertexBuilder ivertexbuilder = typeBuffer.getBuffer(PlayerTileRenderer.getRenderType(profile));
        playerModel.func_225598_a_(matrix, ivertexbuilder, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.func_227865_b_();
    }

    public static void renderPlayerItem(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer typeBuffer, int combinedLight) {
        matrix.func_227860_a_();
        if (stack != null) {
            boolean flag;
            GameProfile gameprofile = null;
            if (stack.func_82837_s()) {
                String stackName = stack.func_200301_q().func_150261_e().toLowerCase();
                boolean spaceFlag = stackName.contains(" ");
                boolean emptyFlag = stackName.isEmpty();
                if (!spaceFlag && !emptyFlag) {
                    if (GAMEPROFILE_CACHE.containsKey(stackName)) {
                        gameprofile = GAMEPROFILE_CACHE.get(stackName);
                    }
                    if (stack.func_77942_o() && gameprofile == null) {
                        CompoundNBT tag = stack.func_77978_p();
                        if (tag.func_150297_b("PlayerProfile", 10)) {
                            GameProfile foundProfile = NBTUtil.func_152459_a((CompoundNBT)tag.func_74775_l("PlayerProfile"));
                            if (foundProfile != null) {
                                GAMEPROFILE_CACHE.put(foundProfile.getName().toLowerCase(), foundProfile);
                            }
                            if (foundProfile.getName().equalsIgnoreCase(stackName)) {
                                gameprofile = foundProfile;
                            }
                        } else if (tag.func_150297_b("PlayerProfile", 8) && !StringUtils.isBlank((CharSequence)tag.func_74779_i("PlayerProfile"))) {
                            GameProfile gameprofile1 = new GameProfile((UUID)null, tag.func_74779_i("PlayerProfile"));
                            GameProfile foundProfile = PlayerTile.updateGameProfile(gameprofile1);
                            tag.func_82580_o("PlayerProfile");
                            tag.func_218657_a("PlayerProfile", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)foundProfile));
                            if (foundProfile != null) {
                                GAMEPROFILE_CACHE.put(foundProfile.getName().toLowerCase(), foundProfile);
                            }
                            if (foundProfile.getName().equalsIgnoreCase(stackName)) {
                                gameprofile = foundProfile;
                            }
                        }
                    }
                    if (gameprofile == null) {
                        GameProfile gameprofile1 = new GameProfile((UUID)null, stackName);
                        if ((gameprofile1 = PlayerTile.updateGameProfile(gameprofile1)) != null) {
                            gameprofile = gameprofile1;
                            GAMEPROFILE_CACHE.put(gameprofile1.getName().toLowerCase(), gameprofile1);
                        }
                    }
                } else {
                    GameProfile gameprofile1;
                    if (GAMEPROFILE_CACHE.containsKey("steve")) {
                        gameprofile = GAMEPROFILE_CACHE.get("steve");
                    }
                    if (gameprofile == null && (gameprofile = PlayerTile.updateGameProfile(gameprofile1 = new GameProfile((UUID)null, "steve"))) != null) {
                        GAMEPROFILE_CACHE.put(gameprofile.getName(), gameprofile);
                    }
                }
            }
            matrix.func_227861_a_(0.5, 1.4, 0.5);
            matrix.func_227862_a_(-1.0f, -1.0f, 1.0f);
            StatuePlayerModel playerModel = model;
            boolean bl = flag = gameprofile != null && gameprofile.isComplete() && SkinUtil.isSlimSkin(gameprofile.getId());
            if (flag && playerModel != slimModel) {
                playerModel = slimModel;
            }
            IVertexBuilder ivertexbuilder = typeBuffer.getBuffer(PlayerTileRenderer.getRenderType(gameprofile));
            playerModel.func_225598_a_(matrix, ivertexbuilder, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrix.func_227865_b_();
    }

    private static RenderType getRenderType(@Nullable GameProfile gameProfileIn) {
        if (gameProfileIn == null || !gameProfileIn.isComplete()) {
            return RenderType.func_228640_c_((ResourceLocation)defaultTexture);
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        Map map = minecraft.func_152342_ad().func_152788_a(gameProfileIn);
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return RenderType.func_228644_e_((ResourceLocation)minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
        }
        return RenderType.func_228640_c_((ResourceLocation)DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)gameProfileIn)));
    }
}

