/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen.info;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InfoArrowWidget
extends AbstractButtonWidget
implements IHoverTextWidget {
    private static final ResourceLocation BUTTONS = new ResourceLocation("tesseract", "textures/gui/page_navigation.png");
    private final boolean left;
    private final Supplier<Integer> currentPage;
    private final Supplier<Integer> numberOfPages;

    public InfoArrowWidget(int x, int y, int width, int height, boolean left, Supplier<Integer> currentPage, Supplier<Integer> numberOfPages, Consumer<Integer> setPage) {
        super(x, y, width, height, () -> setPage.accept(left ? (Integer)currentPage.get() - 1 : (Integer)currentPage.get() + 1));
        this.left = left;
        this.currentPage = currentPage;
        this.numberOfPages = numberOfPages;
    }

    protected ITextComponent getNarrationMessage() {
        return this.getHoverText();
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ScreenUtils.bindTexture((ResourceLocation)BUTTONS);
        boolean active = this.left ? this.currentPage.get() > 0 : this.currentPage.get() < this.numberOfPages.get();
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)(this.left ? 0.0f : 0.6111111f), (float)((float)(active ? (this.hovered ? 1 : 0) : 3) / 4.0f), (float)0.3888889f, (float)0.25f);
    }

    public ITextComponent getHoverText() {
        return new TranslationTextComponent("gui.tesseract.info." + (this.left ? "back" : "forward"));
    }
}

